/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.SliderTickMarkRendererFactory;

public class LinearSliderTickMarkRenderer
extends Renderer {
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer tintedRenderer;
    @NotNull
    protected final Renderer untintedRenderer;

    public LinearSliderTickMarkRenderer(@NotNull SliderConfiguration g, @NotNull SliderTickMarkRendererFactory tickRendererFactory) {
        this.g = g;
        this.tintedRenderer = tickRendererFactory.getSliderTickMarkRenderer(g, true);
        this.untintedRenderer = tickRendererFactory.getSliderTickMarkRenderer(g, false);
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        int tickCount = this.g.getNumberOfTickMarks();
        if (tickCount < 2) {
            return;
        }
        float width = compositor.getWidth();
        float height = compositor.getHeight();
        AquaUIPainter.Size sz = this.g.getSize();
        boolean isHorizontal = this.g.isHorizontal();
        boolean isRTL = this.g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
        double value = this.g.getValue();
        double thickness = JNRUtils.size(sz, 2, 2, 1);
        double length = JNRUtils.size(sz, 8, 8, 7);
        if (isHorizontal) {
            width = (float)((double)width - thickness);
            double x = 0.0;
            double spacing = width / (float)(tickCount - 1);
            for (int i = 0; i < tickCount; ++i) {
                double v = isRTL ? 1.0 - x / (double)width : x / (double)width;
                boolean isTinted = v <= value;
                this.drawTick(compositor, isTinted, x, 0.0, thickness, length);
                x += spacing;
            }
        } else {
            height = (float)((double)height - thickness);
            double y = 0.0;
            double spacing = height / (float)(tickCount - 1);
            for (int i = 0; i < tickCount; ++i) {
                double v = 1.0 - y / (double)height;
                boolean isTinted = v <= value;
                this.drawTick(compositor, isTinted, 0.0, y, length, thickness);
                y += spacing;
            }
        }
    }

    private void drawTick(@NotNull ReusableCompositor compositor, boolean isTinted, double x, double y, double w, double h) {
        Renderer tr = isTinted ? this.tintedRenderer : this.untintedRenderer;
        Rectangle2D.Double tickBounds = new Rectangle2D.Double(x, y, w, h);
        Renderer r = Renderer.createOffsetRenderer(tr, tickBounds);
        r.composeTo(compositor);
    }
}

