/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.geom.GeneralRoundRectangle;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.BigSurLayoutInfo;
import org.violetlib.jnr.aqua.impl.YosemiteOutliner;

public class BigSurOutliner
extends YosemiteOutliner {
    public BigSurOutliner(@NotNull BigSurLayoutInfo uiLayout) {
        super(uiLayout);
    }

    @Override
    @Nullable
    protected Shape getButtonOutline(@NotNull Rectangle2D bounds, @NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.ButtonState bs = BigSurOutliner.getButtonState(g);
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO || bw == AquaUIPainter.ButtonWidget.BUTTON_HELP || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            switch (bw) {
                case BUTTON_HELP: {
                    width += (double)BigSurOutliner.size2D(sz, -7.0f, -4.0f, 0.0f, -2.0f);
                    height += (double)BigSurOutliner.size2D(sz, -6.5, -3.5, -1.0, -2.0);
                    x += (double)BigSurOutliner.size2D(sz, 3.0, 2.0, -0.5, 0.5);
                    y += (double)BigSurOutliner.size2D(sz, 0.0, -0.5, 1.0);
                    break;
                }
                case BUTTON_ROUND: {
                    width += -5.0;
                    height += (double)BigSurOutliner.size2D(sz, -4.0f, -5.0f, -5.0f, -5.0f);
                    x += (double)BigSurOutliner.size2D(sz, 2.5, 2.0, 2.5);
                    y += (double)BigSurOutliner.size2D(sz, 3.0, 4.0, 5.5, 3.5);
                    break;
                }
                case BUTTON_ROUND_TEXTURED: {
                    width -= 1.0;
                    height -= 2.0;
                    break;
                }
                case BUTTON_ROUND_TEXTURED_TOOLBAR: {
                    width += (double)BigSurOutliner.size2D(sz, -4.0, -4.5, -3.5, -3.5);
                    height += (double)BigSurOutliner.size2D(sz, -4.0, -5.0, -3.5, -3.5);
                    x += (double)BigSurOutliner.size2D(sz, 2.0, 2.0, 1.5, 1.5);
                    y += (double)BigSurOutliner.size2D(sz, 2.0f, 2.0f, 1.0f, 1.0f);
                }
            }
            if (height > width && !bw.isTextured()) {
                double excess = height - width;
                y += excess / 2.0;
                height = width;
            }
            return new Ellipse2D.Double(x, y, width, height);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL || bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT || bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return bounds;
        }
        double corner = 8.0;
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            x += (double)BigSurOutliner.size2D(sz, 0.0, 0.5, 0.5, 0.5);
            y += (double)BigSurOutliner.size2D(sz, 2.0, 0.5, 0.5, 0.5);
            height += (double)BigSurOutliner.size2D(sz, -2.0f, -2.0f, -2.0f, -2.0f);
            width += (double)BigSurOutliner.size2D(sz, 0.0f, -1.0f, -1.0f, -1.0f);
            if (sz == AquaUIPainter.Size.REGULAR ? bs == AquaUIPainter.ButtonState.ON : bs != AquaUIPainter.ButtonState.STATELESS && bs != AquaUIPainter.ButtonState.OFF) {
                x += (double)BigSurOutliner.size2D(sz, 0.5, 0.0, 0.0);
                y += (double)BigSurOutliner.size2D(sz, 1.0, -0.5, -0.5);
                width += (double)BigSurOutliner.size2D(sz, -1.0f, 0.0f, 0.0f);
                height += (double)BigSurOutliner.size2D(sz, -1.0, 0.5, 1.0);
            } else if (sz == AquaUIPainter.Size.LARGE) {
                height += -0.5;
            } else if (sz == AquaUIPainter.Size.SMALL) {
                y += -0.5;
            } else if (sz == AquaUIPainter.Size.MINI) {
                y += -0.5;
                height += 1.0;
            }
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            corner = 10.0;
            x += (double)BigSurOutliner.size2D(sz, 0.5, 0.5, 0.5);
            y += (double)BigSurOutliner.size2D(sz, 0.5, 0.5, 0.5);
            height += (double)BigSurOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
            width += (double)BigSurOutliner.size2D(sz, -1.0f, -1.0f, -1.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            corner = 5.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            x += (double)BigSurOutliner.size2D(sz, 2.5, 3.5, 5.5, 3.5);
            y += (double)BigSurOutliner.size2D(sz, 2.5, 2.5, 4.0, 0.5);
            width += (double)BigSurOutliner.size2D(sz, -5.0f, -7.0f, -11.0f, -5.0f);
            height += (double)BigSurOutliner.size2D(sz, -5.0f, -5.0f, -9.0f, -2.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            height -= 1.0;
            corner = 16.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            corner = 6.0;
            y += (double)BigSurOutliner.size2D(sz, 0.5, 0.0, 0.0, 0.0);
            height += (double)BigSurOutliner.size2D(sz, -1.0f, 0.0f, 0.0f, 0.0f);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            y += 1.0;
            height += -3.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            width -= 0.5;
            corner = 3.0;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            height -= 0.5;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            y += 0.5;
            height -= 1.0;
            corner = BigSurOutliner.size(sz, 16, 15, 14);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            corner = 10.0;
            x += 1.5;
            y += 1.5;
            width += -3.5;
            height += -5.5;
        }
        return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
    }

    @NotNull
    private static AquaUIPainter.ButtonState getButtonState(@NotNull ButtonLayoutConfiguration g) {
        if (g instanceof ButtonConfiguration) {
            ButtonConfiguration bg = (ButtonConfiguration)g;
            return bg.getButtonState();
        }
        return AquaUIPainter.ButtonState.STATELESS;
    }

    @Override
    @Nullable
    protected Shape getSegmentedButtonOutline(@NotNull Rectangle2D bounds, @NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Position pos = g.getPosition();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        boolean isLeft = pos == AquaUIPainter.Position.FIRST;
        boolean useOnly = pos == AquaUIPainter.Position.ONLY;
        double corner = 8.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                corner = 6.0;
                if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SLIDER || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    useOnly = true;
                }
                float extraTopForRegular = 0.5f;
                x += (double)BigSurOutliner.size2D(sz, isLeft ? 0.5f : 0.0f, 0.0f, 0.0f);
                y += (double)BigSurOutliner.size2D(sz, (double)(0.5f + extraTopForRegular), 0.5, 0.5);
                height += (double)BigSurOutliner.size2D(sz, -2.0f, -2.0f, -2.0f);
                width += (double)BigSurOutliner.size2D(sz, -0.5, 0.0, 0.0);
                if (sz == AquaUIPainter.Size.SMALL || sz == AquaUIPainter.Size.MINI) {
                    if (pos == AquaUIPainter.Position.FIRST) {
                        x += 0.5;
                        width -= 0.5;
                    } else if (pos == AquaUIPainter.Position.LAST) {
                        width -= 0.5;
                    } else if (pos == AquaUIPainter.Position.ONLY) {
                        x += 0.5;
                        width -= 1.0;
                    }
                }
                if (bw != AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB && !bw.isSlider()) break;
                double widthDelta = -1.5;
                if (sz == AquaUIPainter.Size.REGULAR) {
                    if (pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY) {
                        widthDelta = -0.5;
                    }
                } else if (sz == AquaUIPainter.Size.SMALL) {
                    if (pos == AquaUIPainter.Position.ONLY) {
                        widthDelta = -0.5;
                    }
                } else if (sz == AquaUIPainter.Size.MINI) {
                    widthDelta = -0.5;
                }
                width += (double)((float)widthDelta);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                width += (double)BigSurOutliner.size2D(sz, 0.0f, 0.0f, 0.0f);
                height += (double)BigSurOutliner.size2D(sz, -1.0f, -1.0f, -1.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                width += (double)BigSurOutliner.size2D(sz, 0.0f, 0.0f, 0.0f);
                height += (double)BigSurOutliner.size2D(sz, -1.0f, -2.0f, -1.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                if (pos == AquaUIPainter.Position.ONLY || pos == AquaUIPainter.Position.FIRST) {
                    width -= 0.5;
                }
                if (pos == AquaUIPainter.Position.MIDDLE) {
                    x -= 0.5;
                }
                height -= (double)BigSurOutliner.size2D(sz, 1.0, 0.5, 1.0);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                corner = 0.0;
            }
        }
        if (useOnly) {
            return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
        }
        if (pos == AquaUIPainter.Position.FIRST) {
            return new GeneralRoundRectangle(x, y, width, height, corner, corner, 0.0, 0.0, 0.0, 0.0, corner, corner);
        }
        if (pos == AquaUIPainter.Position.LAST) {
            return new GeneralRoundRectangle(x, y, width, height, 0.0, 0.0, corner, corner, corner, corner, 0.0, 0.0);
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    @Nullable
    protected Shape getPopUpButtonOutline(@NotNull Rectangle2D bounds, @NotNull PopupButtonLayoutConfiguration g) {
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN) {
            double x = bounds.getX();
            double y = bounds.getY();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double corner = BigSurOutliner.size2D(sz, 12.0f, 10.0f, 8.0f, 8.0f);
            if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN) {
                x += (double)BigSurOutliner.size2D(sz, 1.5, -0.5, 0.5, 1.5);
                width += (double)BigSurOutliner.size2D(sz, -3.0f, 0.0f, -1.0f, -3.0f);
                y += (double)BigSurOutliner.size2D(sz, 1.5, -0.5, 0.5, 0.5);
                height += (double)BigSurOutliner.size2D(sz, -2.0f, -1.0f, -2.0f, -2.0f);
            } else {
                x += (double)BigSurOutliner.size2D(sz, 2.5, 0.5, 0.5, 0.5);
                width += (double)BigSurOutliner.size2D(sz, -4.0f, -1.0f, -1.0f, -1.0f);
                y += (double)BigSurOutliner.size2D(sz, 1.0, -0.5, 0.0, 0.5);
                height += (double)BigSurOutliner.size2D(sz, -2.0, -1.5, -2.0, -2.0);
            }
            return new RoundRectangle2D.Double(x, y, width, height, corner, corner);
        }
        return super.getPopUpButtonOutline(bounds, g);
    }

    @Override
    @Nullable
    protected Shape getComboBoxOutline(@NotNull Rectangle2D bounds, @NotNull ComboBoxLayoutConfiguration g) {
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        AquaUIPainter.ComboBoxWidget widget = g.getWidget();
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX) {
            AquaUIPainter.Size sz = g.getSize();
            double corner = BigSurOutliner.size2D(sz, 10.0f, 8.0f, 6.0f);
            return new GeneralRoundRectangle(x += (double)BigSurOutliner.size2D(sz, 0.0f, 0.0f, 0.0f), y += (double)BigSurOutliner.size2D(sz, 0.5f, 0.5f, 0.5f), width += (double)BigSurOutliner.size2D(sz, -1.0f, -1.0f, -1.0f), height += (double)BigSurOutliner.size2D(sz, -1.0f, -2.0f, -1.0f), corner, corner, corner, corner, corner, corner, corner, corner);
        }
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            Insetter insets = this.uiLayout.getComboBoxEditorInsets(g);
            return insets.applyToBounds2D(bounds);
        }
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            double corner = 8.0;
            return new GeneralRoundRectangle(x += 0.5, y, width -= 1.0, height -= 1.0, corner, corner, corner, corner, corner, corner, corner, corner);
        }
        return null;
    }

    @Override
    @Nullable
    protected Shape getSliderThumbOutline(@NotNull Rectangle2D bounds, @NotNull SliderThumbLayoutConfiguration g) {
        double h;
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbOutline(bounds, g);
        }
        Insetter trackInsets = this.uiLayout.getSliderTrackPaintingInsets(g);
        Insetter insets = this.uiLayout.getSliderThumbInsets(g, g.getThumbPosition());
        Rectangle2D tb = insets.applyToBounds2D(trackInsets.applyToBounds2D(bounds));
        boolean isCircle = !g.hasTickMarks();
        AquaUIPainter.Size sz = g.getSize();
        float length = BigSurOutliner.size2D(sz, 20.0, 17.0, 13.5);
        float width = isCircle ? length : BigSurOutliner.size2D(sz, 8.0f, 9.0f, 8.0f);
        double x = g.isVertical() ? (double)BigSurOutliner.size2D(sz, 2.0, 1.5, 3.0) : (double)BigSurOutliner.size2D(sz, 2.0, 1.5, 3.0);
        double y = g.isHorizontal() ? (double)BigSurOutliner.size2D(sz, 1.5, 1.5, 3.0) : (double)BigSurOutliner.size2D(sz, 1.5, 1.0, 2.5);
        double w = g.isHorizontal() ? (double)width : (double)length;
        double d = h = g.isHorizontal() ? (double)(length + BigSurOutliner.size2D(sz, 0.5, 0.0, 0.0)) : (double)width;
        if (!isCircle) {
            x += g.isVertical() ? (double)BigSurOutliner.size2D(sz, 0.0, 0.0, -1.5) : (double)BigSurOutliner.size2D(sz, 0.5, 0.0, -1.5);
            y += g.isVertical() ? (double)BigSurOutliner.size2D(sz, 1.0f, 1.0f, -1.0f) : (double)BigSurOutliner.size2D(sz, 0.5, 0.5, -1.0);
            h += (double)BigSurOutliner.size2D(sz, 0.0f, -1.0f, 0.0f);
        }
        x += tb.getX();
        y += tb.getY();
        if (isCircle) {
            return new Ellipse2D.Double(x, y, w, h);
        }
        float corner = 6.0f;
        return new RoundRectangle2D.Double(x, y, w, h, corner, corner);
    }
}

