/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class LegacyScrollBarPainterExtension
implements PainterExtension {
    @NotNull
    private final AquaUILayoutInfo uiLayout;
    @NotNull
    private final ScrollBarConfiguration g;
    private final boolean showThumb;
    private final boolean isRollover;
    @NotNull
    private final Colors colors;

    public LegacyScrollBarPainterExtension(@NotNull AquaUILayoutInfo uiLayout, @NotNull ScrollBarConfiguration g, @Nullable VAppearance appearance) {
        this.uiLayout = uiLayout;
        this.g = g;
        boolean isDark = appearance != null && appearance.isDark();
        this.showThumb = g.getKnobWidget() != AquaUIPainter.ScrollBarKnobWidget.NONE;
        this.isRollover = g.getState() == AquaUIPainter.State.ROLLOVER;
        this.colors = Colors.getColors(appearance);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        g = (Graphics2D)g.create();
        g.clip(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        boolean isVertical = height > width;
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        g.setColor(this.getTrackBackgroundColor());
        g.fill(bounds);
        Color innerBorderColor = this.getInnerBorderColor();
        Color outerBorderColor = this.getOuterBorderColor();
        if (innerBorderColor != null || outerBorderColor != null) {
            int w = (int)width;
            int h = (int)height;
            if (isVertical) {
                if (innerBorderColor != null) {
                    g.setColor(innerBorderColor);
                    g.fillRect(0, 0, 1, h);
                }
                if (outerBorderColor != null) {
                    g.setColor(outerBorderColor);
                    g.fillRect(w - 1, 0, 1, h);
                }
            } else {
                if (innerBorderColor != null) {
                    g.setColor(innerBorderColor);
                    g.fillRect(0, 0, w, 1);
                }
                if (outerBorderColor != null) {
                    g.setColor(outerBorderColor);
                    g.fillRect(0, h - 1, w, 1);
                }
            }
        }
        if (this.showThumb) {
            Shape thumbShape = this.createThumbShape(width, height);
            g.setColor(this.getThumbColor());
            g.fill(thumbShape);
            Color thumbBorderColor = this.getThumbBorderColor();
            if (thumbBorderColor != null) {
                float thickness = this.getThumbBorderThickness();
                g.setColor(thumbBorderColor);
                g.setStroke(new BasicStroke(thickness * 1.5f));
                Shape thumbBorderShape = this.createThumbShape(width, height);
                g.clip(thumbShape);
                g.draw(thumbBorderShape);
            }
        }
        g.dispose();
    }

    @NotNull
    protected Shape createThumbShape(float width, float height) {
        boolean isVertical = height > width;
        double leftTop = 3.5;
        double rightBottom = 3.5;
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        Rectangle2D thumbBounds = this.uiLayout.getScrollBarThumbBounds(bounds, this.g);
        if (isVertical) {
            double w = (double)width - leftTop - rightBottom;
            return new RoundRectangle2D.Double(leftTop, thumbBounds.getY(), w, thumbBounds.getHeight(), w, w);
        }
        double h = (double)height - leftTop - rightBottom;
        return new RoundRectangle2D.Double(thumbBounds.getX(), leftTop, thumbBounds.getWidth(), h, h, h);
    }

    @Nullable
    protected Color getInnerBorderColor() {
        return this.colors.getOptional("legacyScrollBarInnerBorder");
    }

    @Nullable
    protected Color getOuterBorderColor() {
        return this.colors.getOptional("legacyScrollBarOuterBorder");
    }

    protected float getThumbBorderThickness() {
        return 1.0f;
    }

    @NotNull
    protected Color getTrackBackgroundColor() {
        return this.colors.get("legacyScrollBarTrack");
    }

    @NotNull
    protected Color getThumbColor() {
        Color c;
        if (this.isRollover && (c = this.colors.getOptional("legacyScrollBarThumb_rollover")) != null) {
            return c;
        }
        return this.colors.get("legacyScrollBarThumb");
    }

    @Nullable
    protected Color getThumbBorderColor() {
        Color c;
        if (this.isRollover && (c = this.colors.getOptional("legacyScrollBarThumbBorder_rollover")) != null) {
            return c;
        }
        return this.colors.getOptional("legacyScrollBarThumbBorder");
    }
}

