/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.impl.SliderHorizontalTickPainter;
import org.violetlib.jnr.aqua.impl.SliderVerticalTickPainter;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class LinearSliderPainterExtension
implements PainterExtension {
    @NotNull
    protected final AquaUILayoutInfo uiLayout;
    @NotNull
    protected final SliderConfiguration sg;
    @NotNull
    protected final Colors colors;

    public LinearSliderPainterExtension(@NotNull AquaUILayoutInfo uiLayout, @NotNull SliderConfiguration g, @Nullable VAppearance appearance) {
        this.uiLayout = uiLayout;
        this.sg = g;
        this.colors = Colors.getColors(appearance);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.SliderWidget sw = this.sg.getWidget();
        if (this.sg.hasTickMarks()) {
            this.paintLinearTickMarks(g, width, height);
        }
    }

    protected void paintLinearTickMarks(@NotNull Graphics2D g, float width, float height) {
        Color tickColor = this.colors.get("linearSliderTick");
        AquaUIPainter.SliderWidget sw = this.sg.getWidget();
        AquaUIPainter.Size sz = this.sg.getSize();
        boolean isHorizontal = sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT;
        int tickCount = this.sg.getNumberOfTickMarks();
        AquaUIPainter.TickMarkPosition position = this.sg.getTickMarkPosition();
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
        double w = 1.0;
        double h = JNRUtils.size(sz, 4, 3, 3);
        double sep = 2.0;
        if (isHorizontal) {
            double x0;
            double x1;
            double y;
            boolean isAbove = position == AquaUIPainter.TickMarkPosition.ABOVE;
            double d = y = isAbove ? sep : (double)height - sep - h;
            if (tickCount == 1) {
                x0 = x1 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 0.5);
            } else {
                x0 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 0.0);
                x1 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 1.0);
                if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
                    double temp = x0;
                    x0 = x1;
                    x1 = temp;
                }
            }
            SliderHorizontalTickPainter tp = new SliderHorizontalTickPainter(tickColor, w, h, x0, x1, y, tickCount);
            tp.paint(g);
        } else {
            double y0;
            double y1;
            double x;
            boolean isLeft = position == AquaUIPainter.TickMarkPosition.LEFT;
            double d = x = isLeft ? sep : (double)width - sep - h;
            if (tickCount == 1) {
                y0 = y1 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 0.5);
            } else {
                y0 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 0.0);
                y1 = this.uiLayout.getSliderThumbCenter(bounds, this.sg, 1.0);
                if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
                    double temp = y0;
                    y0 = y1;
                    y1 = temp;
                }
            }
            SliderVerticalTickPainter tp = new SliderVerticalTickPainter(tickColor, w, h, x, y0, y1, tickCount);
            tp.paint(g);
        }
    }
}

