/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.RenderInsets;
import org.violetlib.jnr.aqua.impl.SegmentedControl1LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControl4LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControlLayoutInfo;
import org.violetlib.jnr.impl.JNRUtils;

public class SegmentedControlDescriptions {
    @NotNull
    public RenderInsets getInsets(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        int version = AquaUIPainterBase.internalGetSegmentedButtonRenderingVersion();
        if (version == 0) {
            return this.getInsets10_10(g, scale);
        }
        if (version == 1) {
            return this.getInsets10_11(g, scale);
        }
        if (version == 3) {
            return this.getInsets10_13new(g, scale);
        }
        if (version == 5) {
            return this.getInsets10_14new(g, scale);
        }
        if (version == 2) {
            return this.getInsets10_13old(g, scale);
        }
        if (version == 4) {
            return this.getInsets10_14old(g, scale);
        }
        if (version == 6) {
            return this.getInsets11(g, scale);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private RenderInsets getInsets10_10(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 0.0, 1.0, 0.51);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = JNRUtils.size2D(sz, 0.0f, 1.0f, 1.0f);
                ha = JNRUtils.size2D(sz, 2.0f, 2.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                top = JNRUtils.size2D(sz, 0.0, 0.0, 0.51);
                ha = JNRUtils.size2D(sz, 1.0f, 0.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                top = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.0, 0.0, 0.51);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets10_11(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 0.0, 1.0, 0.51);
                ha = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = JNRUtils.size2D(sz, 0.0f, 1.0f, 1.0f);
                ha = 2.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                top = JNRUtils.size2D(sz, 0.49, 0.49, 0.0);
                ha = JNRUtils.size2D(sz, 2.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                top = 0.49;
                ha = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                top = JNRUtils.size2D(sz, 0.49, 0.0, 0.0);
                ha = JNRUtils.size2D(sz, 2.0f, 2.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.0, 0.49, 1.0);
                ha = JNRUtils.size2D(sz, 2.0f, 2.0f, 2.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets10_13new(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 1.0, 1.49, 0.0);
                ha = JNRUtils.size2D(sz, 1.0f, 2.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.49, 1.49, 0.49);
                ha = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                top = 0.49;
                ha = 0.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets10_13old(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 1.0, 1.49, 1.0);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = 1.0;
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                top = JNRUtils.size2D(sz, 0.0, 0.49, 0.49);
                ha = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                top = JNRUtils.size2D(sz, 0.49, 0.0, 0.49);
                ha = JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                top = 0.49;
                ha = 0.0;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                top = JNRUtils.size2D(sz, 1.0, 1.49, 0.49);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.49, 1.49, 0.49);
                ha = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets10_14old(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 1.0, 1.49, 0.0);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = 1.0;
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                top = 0.49;
                ha = 0.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                top = JNRUtils.size2D(sz, 0.49, 0.0, 0.49);
                ha = 0.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                top = 0.49;
                ha = 0.0;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                top = JNRUtils.size2D(sz, 1.0, 1.49, 0.49);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.49, 1.49, 0.49);
                ha = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets10_14new(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
                top = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                ha = JNRUtils.size2D(sz, 3.0f, 2.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 1.0f, 1.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                left = 1.0;
                top = 1.0;
                ha = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                top = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                ha = JNRUtils.size2D(sz, 0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    protected RenderInsets getInsets11(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double ha;
        double top;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                left = JNRUtils.size2D(sz, 5.0, 2.0, 2.0, 1.0);
                top = JNRUtils.size2D(sz, 5.0, 1.0, 1.0, 0.0);
                ha = JNRUtils.size2D(sz, 5.0, 1.0, 1.0, 0.0);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                left = JNRUtils.size2D(sz, 5.0, 2.0, 2.0, 1.0);
                top = JNRUtils.size2D(sz, 5.0, 1.0, 1.0, 0.0);
                ha = JNRUtils.size2D(sz, 5.0, 1.0, 1.0, 0.0);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 11.0, 3.0, 2.0, 1.0);
                ha = JNRUtils.size2D(sz, 11.0, 3.0, 2.0, 1.0);
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                top = JNRUtils.size2D(sz, 9.0, 1.0, 1.0, 0.0);
                ha = JNRUtils.size2D(sz, 9.0, 1.0, 1.0, 0.0);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 10.0, 1.0, 2.0, 1.0);
                ha = JNRUtils.size2D(sz, 11.0, 1.0, 2.0, 1.0);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                left = 1.0;
                top = JNRUtils.size2D(sz, 10.0, 1.0, 2.0, 1.0);
                ha = JNRUtils.size2D(sz, 11.0, 0.0, 0.0, 0.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SegmentedControlDescriptions.createRenderInsets(left, top, left * 2.0, ha, scale);
    }

    @NotNull
    public static RenderInsets createRenderInsets(double left, double top, double wa, double ha, int scale) {
        return new RenderInsets((double)SegmentedControlDescriptions.round((float)left, scale), (double)SegmentedControlDescriptions.round((float)top, scale), wa, ha);
    }

    private static float round(float v, int scale) {
        if (scale == 1) {
            return Math.round(v);
        }
        return (float)Math.round(v * (float)scale) / (float)scale;
    }

    @NotNull
    public SegmentedControlLayoutInfo getSegmentLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        if (g.getPosition() == AquaUIPainter.Position.ONLY) {
            return this.getSegment1LayoutInfo(g, scale);
        }
        return this.getSegment4LayoutInfo(g, scale);
    }

    @NotNull
    public SegmentedControl1LayoutInfo getSegment1LayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        SegmentedControl4LayoutInfo layout = this.getSegment4LayoutInfo(g, scale);
        float divider = layout.dividerVisualWidth;
        float first = layout.firstSegmentWidthAdjustment;
        float last = layout.lastSegmentWidthAdjustment;
        float adjustment = first + last - divider;
        int version = AquaUIPainterBase.internalGetSegmentedButtonRenderingVersion();
        if (version == 6) {
            AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
            AquaUIPainter.Size sz = g.getSize();
            switch (bw) {
                case BUTTON_TAB: 
                case BUTTON_SEGMENTED: 
                case BUTTON_SEGMENTED_SLIDER: 
                case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
                case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
                case BUTTON_SEGMENTED_SEPARATED: {
                    adjustment = JNRUtils.size2D(sz, 12.0, 2.0, 2.0, 4.0);
                    if (scale != 2) break;
                    adjustment = (float)((double)adjustment + 0.5);
                    break;
                }
                case BUTTON_SEGMENTED_INSET: 
                case BUTTON_SEGMENTED_SMALL_SQUARE: {
                    adjustment = 2.0f;
                    break;
                }
                case BUTTON_SEGMENTED_TEXTURED: 
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
                case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
                case BUTTON_SEGMENTED_SCURVE: 
                case BUTTON_SEGMENTED_TOOLBAR: {
                    adjustment = 4.0f;
                    break;
                }
                case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
                case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
                case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                    adjustment = 6.0f;
                }
            }
        }
        return new SegmentedControl1LayoutInfo(adjustment);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        int version = AquaUIPainterBase.internalGetSegmentedButtonRenderingVersion();
        if (version == 0) {
            return this.getSegment4LayoutInfo10_10(g, scale);
        }
        if (version == 1) {
            return this.getSegment4LayoutInfo10_11(g, scale);
        }
        if (version == 3) {
            return this.getSegment4LayoutInfo10_13new(g, scale);
        }
        if (version == 5) {
            return this.getSegment4LayoutInfo10_14new(g, scale);
        }
        if (version == 2) {
            return this.getSegment4LayoutInfo10_13old(g, scale);
        }
        if (version == 4) {
            return this.getSegment4LayoutInfo10_14old(g, scale);
        }
        if (version == 6) {
            return this.getSegment4LayoutInfo11(g, scale);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_10(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        SegmentedControl4LayoutInfo.DividerPosition dp2 = SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        double first = 0.0;
        double middle = 1.0;
        double last = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                first = 3.0;
                last = 2.0;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                first = 2.0;
                last = 1.0;
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.LEFT;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = 2.0;
                last = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                first = 4.0;
                last = 3.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SegmentedControl4LayoutInfo.DividerPosition dp = scale == 1 ? SegmentedControl4LayoutInfo.DividerPosition.LEFT : dp2;
        return new SegmentedControl4LayoutInfo(dp, 1.0, first, middle, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_11(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double last;
        double first;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        SegmentedControl4LayoutInfo.DividerPosition dp2 = SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        double middle = 1.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                first = 3.0;
                last = 2.0;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                first = 2.0;
                last = 1.0;
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.LEFT;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = 2.0;
                last = 1.0;
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.RIGHT;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                first = 4.0;
                last = 3.0;
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.RIGHT;
                break;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.RIGHT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SegmentedControl4LayoutInfo.DividerPosition dp = scale == 1 ? SegmentedControl4LayoutInfo.DividerPosition.LEFT : dp2;
        return new SegmentedControl4LayoutInfo(dp, 1.0, first, middle, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_13new(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        double dividerVisualWidth = scale == 2 ? 0.5 : 1.0;
        AquaUIPainter.Size sz = g.getSize();
        SegmentedControl4LayoutInfo.DividerPosition dp2 = SegmentedControl4LayoutInfo.DividerPosition.LEFT;
        double first = 0.0;
        double middle = 1.0;
        double last = 0.0;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        switch (bw) {
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.CENTER;
            }
        }
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_INSET: 
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                first = 2.0;
                last = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = 4.0;
                last = 3.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SegmentedControl4LayoutInfo.DividerPosition dp = scale == 1 ? SegmentedControl4LayoutInfo.DividerPosition.LEFT : dp2;
        return new SegmentedControl4LayoutInfo(dp, dividerVisualWidth, first, middle, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_14new(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        float first = 0.0f;
        float last = 0.0f;
        switch (bw) {
            case BUTTON_SEGMENTED_SEPARATED: {
                first = 2.0f;
                last = 1.0f;
                break;
            }
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                first = 2.0f;
                last = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                first = 2.0f;
                last = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                last = JNRUtils.size2D(sz, 2.0f, 0.0f, 0.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                first = 3.0f;
                last = 2.0f;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = 4.0f;
                last = 3.0f;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new SegmentedControl4LayoutInfo(SegmentedControl4LayoutInfo.DividerPosition.LEFT, 1.0f, first, 1.0f, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_13old(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        SegmentedControl4LayoutInfo.DividerPosition dp2 = SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        double first = 0.0;
        double middle = 1.0;
        double last = 0.0;
        switch (bw) {
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                dp2 = SegmentedControl4LayoutInfo.DividerPosition.RIGHT;
            }
        }
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                first = 4.0;
                last = 3.0;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = 2.0;
                last = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                first = 3.0;
                last = 2.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SegmentedControl4LayoutInfo.DividerPosition dp = scale == 1 ? SegmentedControl4LayoutInfo.DividerPosition.LEFT : dp2;
        return new SegmentedControl4LayoutInfo(dp, 1.0, first, middle, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo10_14old(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        SegmentedControl4LayoutInfo.DividerPosition dp2 = SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        double first = 0.0;
        double middle = 1.0;
        double last = 0.0;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SEPARATED: {
                first = JNRUtils.size2D(sz, 2.0f, 2.0f, 3.0f);
                last = JNRUtils.size2D(sz, 1.0f, 1.0f, 2.0f);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = JNRUtils.size2D(sz, 4.0f, 2.0f, 2.0f);
                last = JNRUtils.size2D(sz, 3.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                first = 4.0;
                last = 3.0;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                first = 2.0;
                last = 1.0;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                first = 3.0;
                last = 2.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new SegmentedControl4LayoutInfo(SegmentedControl4LayoutInfo.DividerPosition.RIGHT, 1.0, first, middle, last);
    }

    @NotNull
    public SegmentedControl4LayoutInfo getSegment4LayoutInfo11(@NotNull SegmentedButtonLayoutConfiguration g, int scale) {
        AquaUIPainter.Size sz = g.getSize();
        double dividerVisualWidth = 1.0;
        double first = 0.0;
        double middle = 0.0;
        double last = 0.0;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                first = JNRUtils.size2D(sz, 13.0, 3.0, 3.0, 5.0);
                middle = JNRUtils.size2D(sz, 13.0, 3.0, 3.0, 5.0);
                last = JNRUtils.size2D(sz, 12.0, 2.0, 2.0, 4.0);
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                first = JNRUtils.size2D(sz, 12.0, 2.0, 2.0, 4.0);
                middle = JNRUtils.size2D(sz, 11.0, 1.0, 1.0, 3.0);
                last = JNRUtils.size2D(sz, 11.0, 1.0, 1.0, 3.0);
                break;
            }
            case BUTTON_SEGMENTED_INSET: 
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                first = 3.0;
                middle = 3.0;
                last = 2.0;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_SCURVE: {
                first = JNRUtils.size2D(sz, 16.0, 5.0, 5.0, 5.0);
                middle = JNRUtils.size2D(sz, 11.0, 5.0, 5.0, 5.0);
                last = JNRUtils.size2D(sz, 15.0, 4.0, 4.0, 4.0);
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                first = JNRUtils.size2D(sz, 16.0, 5.0, 5.0, 5.0);
                middle = JNRUtils.size2D(sz, 11.0, 5.0, 5.0, 5.0);
                last = JNRUtils.size2D(sz, 15.0, 4.0, 4.0, 4.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new SegmentedControl4LayoutInfo(SegmentedControl4LayoutInfo.DividerPosition.LEFT, dividerVisualWidth, first, middle, last);
    }
}

