/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class ThickSplitPaneDividerPainterExtension
implements PainterExtension {
    @NotNull
    protected final SplitPaneDividerConfiguration g;
    @NotNull
    protected final Colors colors;

    public ThickSplitPaneDividerPainterExtension(@NotNull SplitPaneDividerConfiguration g, @Nullable VAppearance appearance) {
        this.g = g;
        this.colors = Colors.getColors(appearance);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        Color dimpleColor = this.colors.get("thickDividerDimple");
        Color dimpleBorderColor = this.colors.getOptional("thickDividerDimpleBorder");
        float d = 6.0f;
        float x = (width - d) / 2.0f;
        float y = (height - d) / 2.0f;
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, d, d);
        g.setColor(dimpleColor);
        g.fill(s);
        if (dimpleBorderColor != null) {
            g.setColor(dimpleBorderColor);
            g.setStroke(new BasicStroke(1.0f));
            s = new Ellipse2D.Double((double)x + 0.5, (double)y + 0.5, d - 1.0f, d - 1.0f);
            g.draw(s);
        }
    }
}

