/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.FloatingInsetter1;
import org.violetlib.jnr.impl.Insetters;

public class TitleBarLayoutInfo {
    private static final int BUTTON_AREA_RIGHT_PAD = 11;
    private static final int DOCUMENT_HEIGHT = 22;
    private static final int UTILITY_HEIGHT = 16;
    private static final int DOCUMENT_DIAMETER = 12;
    private static final int UTILITY_DIAMETER = 11;
    @NotNull
    private final WindowInfo[] windowInfo = new WindowInfo[2];

    public TitleBarLayoutInfo(@NotNull Rectangle[] documentButtonBounds, @NotNull Rectangle[] utilityButtonBounds) {
        this.windowInfo[0] = new WindowInfo(22.0f, documentButtonBounds, 12.0f);
        this.windowInfo[1] = new WindowInfo(16.0f, utilityButtonBounds, 11.0f);
    }

    @NotNull
    public Insetter getButtonInsets(@NotNull TitleBarLayoutConfiguration g, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        ButtonInfo buttonInfo = this.getButtonInfo(g.getWidget(), bw);
        return buttonInfo.insets;
    }

    @NotNull
    public Shape getButtonShape(@NotNull Rectangle2D bounds, @NotNull TitleBarLayoutConfiguration g, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        ButtonInfo buttonInfo = this.getButtonInfo(g.getWidget(), bw);
        return buttonInfo.shape;
    }

    @NotNull
    public Insetter getLabelInsets(@NotNull TitleBarLayoutConfiguration g) {
        WindowInfo w = this.getWindowInfo(g.getWidget());
        return w.labelInsets;
    }

    @Nullable
    public AquaUIPainter.TitleBarButtonWidget identifyButton(@NotNull Rectangle2D bounds, @NotNull TitleBarLayoutConfiguration g, int x, int y) {
        WindowInfo w = this.getWindowInfo(g.getWidget());
        for (int i = 0; i < w.buttonInfo.length; ++i) {
            ButtonInfo buttonInfo = w.buttonInfo[i];
            Rectangle bb = buttonInfo.bounds;
            if (!bb.contains(x, y)) continue;
            return TitleBarLayoutInfo.fromButtonIndex(i);
        }
        return null;
    }

    @NotNull
    protected WindowInfo getWindowInfo(@NotNull AquaUIPainter.TitleBarWidget w) {
        int index = TitleBarLayoutInfo.toWindowTypeIndex(w);
        return this.windowInfo[index];
    }

    @NotNull
    protected ButtonInfo getButtonInfo(@NotNull AquaUIPainter.TitleBarWidget w, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        WindowInfo windowInfo = this.getWindowInfo(w);
        int index = TitleBarLayoutInfo.toButtonIndex(bw);
        return windowInfo.buttonInfo[index];
    }

    public static int toWindowTypeIndex(@NotNull AquaUIPainter.TitleBarWidget w) {
        switch (w) {
            case DOCUMENT_WINDOW: {
                return 0;
            }
            case UTILITY_WINDOW: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int toButtonIndex(@NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        switch (bw) {
            case CLOSE_BOX: {
                return 0;
            }
            case MINIMIZE_BOX: {
                return 1;
            }
            case RESIZE_BOX: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static AquaUIPainter.TitleBarButtonWidget fromButtonIndex(int index) {
        switch (index) {
            case 0: {
                return AquaUIPainter.TitleBarButtonWidget.CLOSE_BOX;
            }
            case 1: {
                return AquaUIPainter.TitleBarButtonWidget.MINIMIZE_BOX;
            }
            case 2: {
                return AquaUIPainter.TitleBarButtonWidget.RESIZE_BOX;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Shape createButtonShape(@NotNull Rectangle bounds, float diameter) {
        float radius = diameter / 2.0f;
        float x = (float)((double)bounds.x + (double)bounds.width / 2.0 - (double)radius);
        float y = (float)((double)bounds.y + (double)bounds.height / 2.0 - (double)radius);
        return new Ellipse2D.Float(x, y, diameter, diameter);
    }

    private static class WindowInfo {
        final float height;
        final float buttonAreaWidth;
        @NotNull
        final ButtonInfo[] buttonInfo;
        @NotNull
        final Insetter labelInsets;

        public WindowInfo(float height, @NotNull Rectangle[] buttonBounds, float buttonDiameter) {
            int buttonCount = buttonBounds.length;
            Rectangle lastBounds = buttonBounds[buttonCount - 1];
            this.height = height;
            this.buttonAreaWidth = lastBounds.x + lastBounds.width + 11;
            this.buttonInfo = new ButtonInfo[buttonCount];
            for (int i = 0; i < buttonCount; ++i) {
                this.buttonInfo[i] = new ButtonInfo(buttonBounds[i], buttonDiameter);
            }
            this.labelInsets = Insetters.createFixed(1.0f, this.buttonAreaWidth, 1.0f, 1.0f);
        }
    }

    private static class ButtonInfo {
        @NotNull
        final Rectangle bounds;
        @NotNull
        final Shape shape;
        @NotNull
        final Insetter insets;

        public ButtonInfo(@NotNull Rectangle bounds, float diameter) {
            this.bounds = bounds;
            this.shape = TitleBarLayoutInfo.createButtonShape(bounds, diameter);
            FloatingInsetter1 horizontal = FloatingInsetter1.createLeftTopAligned(bounds.width, bounds.x);
            FloatingInsetter1 vertical = FloatingInsetter1.createLeftTopAligned(bounds.height, bounds.y);
            this.insets = new CombinedInsetter(horizontal, vertical);
        }
    }
}

