/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.jrs.JRSUIState;
import org.violetlib.vappearances.VAppearance;

public class JRSPixelsKey
implements ImageCache.PixelsKey {
    private final int pixelCount;
    private final int hash;
    private final int scaleFactor;
    private final int w;
    private final int h;
    @NotNull
    private final JRSUIState state;
    @NotNull
    private final VAppearance appearance;

    public JRSPixelsKey(int scaleFactor, int w, int h, @NotNull JRSUIState state, @NotNull VAppearance appearance) {
        this.pixelCount = w * h;
        this.scaleFactor = scaleFactor;
        this.w = w;
        this.h = h;
        this.state = state;
        this.appearance = appearance;
        this.hash = this.hash();
    }

    @Override
    public int getPixelCount() {
        return this.pixelCount;
    }

    private int hash() {
        int hash = this.scaleFactor;
        hash = 31 * hash + this.w;
        hash = 31 * hash + this.h;
        hash = 31 * hash + this.state.hashCode();
        hash = 31 * hash + this.appearance.hashCode();
        return hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof JRSPixelsKey) {
            JRSPixelsKey key = (JRSPixelsKey)obj;
            return this.scaleFactor == key.scaleFactor && this.w == key.w && this.h == key.h && this.state.equals(key.state) && this.appearance.equals(key.appearance);
        }
        return false;
    }
}

