/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.jrs.JRSUIConstants;
import org.violetlib.jnr.impl.jrs.JRSUIControl;
import org.violetlib.jnr.impl.jrs.JRSUIState;

public class JRSRenderer
implements BasicRenderer {
    @NotNull
    protected final JRSUIControl control;
    @NotNull
    protected final JRSUIState state;

    public JRSRenderer(@NotNull JRSUIControl control, @NotNull JRSUIState state) {
        this.control = control;
        this.state = state;
    }

    @Nullable
    public JRSUIState getControlState() {
        return this.state;
    }

    public boolean isAnimating() {
        return this.state.is(JRSUIConstants.Animating.YES);
    }

    @Override
    public void render(@NotNull int[] data, int rw, int rh, float w, float h) {
        float ww = (float)Math.ceil(w);
        float hh = (float)Math.ceil(h);
        if (ww == (float)rw && hh == (float)rh) {
            w = ww;
            h = hh;
        }
        this.control.set(this.state);
        this.control.paint(data, rw, rh, 0.0, 0.0, w, h);
    }
}

