/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class BasicRendererRenderer
extends Renderer {
    @NotNull
    private final BasicRenderer r;
    @NotNull
    private final RendererDescription rd;

    public BasicRendererRenderer(@NotNull BasicRenderer r, @NotNull RendererDescription rd) {
        this.r = r;
        this.rd = rd;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        if (this.rd.isTrivial()) {
            compositor.composeRenderer(this.r);
        } else {
            int scaleFactor = compositor.getScaleFactor();
            float width = compositor.getWidth();
            float height = compositor.getHeight();
            Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, width, height);
            RasterDescription sd = this.rd.getRasterBounds(bounds, scaleFactor);
            int x = Math.round((float)scaleFactor * sd.getX());
            int y = Math.round((float)scaleFactor * sd.getY());
            int w = (int)Math.ceil((float)scaleFactor * sd.getWidth());
            int h = (int)Math.ceil((float)scaleFactor * sd.getHeight());
            compositor.composeRenderer(this.r, x, y, w, h);
        }
    }

    @Override
    @NotNull
    public BasicRenderer getBasicRenderer() {
        return this.r;
    }

    @Override
    @NotNull
    public RendererDescription getRendererDescription() {
        return this.rd;
    }
}

