/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererPainter;

public abstract class CachingRendererPainter
extends RendererPainter {
    private static boolean isCachingEnabled = CachingRendererPainter.getDefaultCachingEnabled();

    private static boolean getDefaultCachingEnabled() {
        String s = System.getProperty("VAqua.enableCaching");
        if ("false".equals(s)) {
            System.err.println("VAqua caching disabled");
            return false;
        }
        return true;
    }

    public static void setCachingEnabled(boolean b) {
        if (b != isCachingEnabled) {
            isCachingEnabled = b;
            System.err.println("VAqua caching " + (isCachingEnabled ? "enabled" : "disabled"));
        }
    }

    protected CachingRendererPainter(@NotNull Renderer r, float width, float height) {
        super(r, width, height);
    }

    @Override
    @Nullable
    protected Image getImage(int scaleFactor, int width, int height) {
        ImageCache.PixelsKey key = this.createKey(scaleFactor, width, height);
        if (key != null && isCachingEnabled) {
            ImageCache cache = ImageCache.getInstance();
            Image im = cache.getImage(key);
            if (im != null) {
                return im;
            }
            im = this.createImage(scaleFactor, width, height);
            if (im != null) {
                cache.setImage(key, im);
            }
            return im;
        }
        return this.createImage(scaleFactor, width, height);
    }

    @Nullable
    protected abstract ImageCache.PixelsKey createKey(int var1, int var2, int var3);
}

