/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.Insetter1;

public class CombinedInsetter
implements Insetter {
    @NotNull
    private static final CombinedInsetter TRIVIAL = new CombinedInsetter(new FixedInsetter1(0.0f, 0.0f), new FixedInsetter1(0.0f, 0.0f));
    @NotNull
    private final Insetter1 horizontal;
    @NotNull
    private final Insetter1 vertical;

    @NotNull
    public static Insetter trivial() {
        return TRIVIAL;
    }

    public CombinedInsetter(@NotNull Insetter1 horizontal, @NotNull Insetter1 vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    @Override
    @NotNull
    public Rectangle2D applyToBounds2D(@NotNull Rectangle2D bounds) {
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        return this.apply(x, y, w, h);
    }

    @Override
    @NotNull
    public Rectangle2D apply2D(double width, double height) {
        return this.apply(0.0f, 0.0f, (float)width, (float)height);
    }

    @NotNull
    protected Rectangle2D apply(float cx, float cy, float cwidth, float cheight) {
        float x = cx + this.horizontal.getRegionOrigin(cwidth);
        float y = cy + this.vertical.getRegionOrigin(cheight);
        float w = this.horizontal.getRegionSize(cwidth);
        float h = this.vertical.getRegionSize(cheight);
        return new Rectangle2D.Float(x, y, w, h);
    }

    @Override
    @NotNull
    public Rectangle applyToBounds(@NotNull Rectangle bounds) {
        return this.apply(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    @NotNull
    public Rectangle apply(int width, int height) {
        return this.apply(0, 0, width, height);
    }

    @NotNull
    protected Rectangle apply(int cx, int cy, int cwidth, int cheight) {
        double xx = (float)cx + this.horizontal.getRegionOrigin(cwidth);
        double ww = this.horizontal.getRegionSize(cwidth);
        int x = (int)Math.ceil(xx);
        int w = (int)Math.floor(ww -= (double)x - xx);
        double yy = (float)cy + this.vertical.getRegionOrigin(cheight);
        double hh = this.vertical.getRegionSize(cheight);
        int y = (int)Math.ceil(yy);
        int h = (int)Math.floor(hh -= (double)y - yy);
        return new Rectangle(x, y, w, h);
    }

    @Override
    public boolean isInvertible() {
        return this.horizontal.isInvertible() && this.vertical.isInvertible();
    }

    @Override
    @NotNull
    public Dimension2D expand2D(@NotNull Dimension2D regionSize) throws InsetterNotInvertibleException {
        int width = (int)Math.ceil(this.horizontal.getComponentSize((float)regionSize.getWidth()));
        int height = (int)Math.ceil(this.vertical.getComponentSize((float)regionSize.getHeight()));
        return new Dimension(width, height);
    }

    @Override
    @NotNull
    public Dimension expand(@NotNull Dimension regionSize) throws InsetterNotInvertibleException {
        int width = (int)Math.ceil(this.horizontal.getComponentSize(regionSize.width));
        int height = (int)Math.ceil(this.vertical.getComponentSize(regionSize.height));
        return new Dimension(width, height);
    }

    @Override
    @Nullable
    public Insets2D asInsets2D() {
        float left = this.horizontal.getFixedInset1();
        if (left < 0.0f) {
            return null;
        }
        float right = this.horizontal.getFixedInset2();
        if (right < 0.0f) {
            return null;
        }
        float top = this.vertical.getFixedInset1();
        if (top < 0.0f) {
            return null;
        }
        float bottom = this.vertical.getFixedInset2();
        if (bottom < 0.0f) {
            return null;
        }
        return new Insets2D(top, left, bottom, right);
    }

    @Override
    @Nullable
    public Insets asInsets() {
        float left = this.horizontal.getFixedInset1();
        if (left < 0.0f) {
            return null;
        }
        float right = this.horizontal.getFixedInset2();
        if (right < 0.0f) {
            return null;
        }
        float top = this.vertical.getFixedInset1();
        if (top < 0.0f) {
            return null;
        }
        float bottom = this.vertical.getFixedInset2();
        if (bottom < 0.0f) {
            return null;
        }
        int tn = (int)Math.ceil(top);
        int ln = (int)Math.ceil(left);
        int bn = (int)Math.ceil(bottom);
        int rn = (int)Math.ceil(right);
        return new Insets(tn, ln, bn, rn);
    }

    public float getFixedRegionWidth() {
        return this.horizontal.getFixedRegionSize();
    }

    public float getFixedRegionHeight() {
        return this.vertical.getFixedRegionSize();
    }
}

