/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.ReusableCompositor;

class CompositeBasicRenderer
implements BasicRenderer {
    @NotNull
    private final List<BasicRenderer> renderers;

    public CompositeBasicRenderer(@NotNull List<BasicRenderer> renderers) {
        this.renderers = renderers;
    }

    @Override
    public void render(@NotNull int[] data, int rw, int rh, float w, float h) {
        int scaleFactor = (int)Math.ceil((float)rw / w);
        ReusableCompositor compositor = new ReusableCompositor(data, rw, rh, scaleFactor);
        for (BasicRenderer renderer : this.renderers) {
            compositor.composeRenderer(renderer);
        }
    }
}

