/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RasterDescription;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;

class OffsetRendererX
extends Renderer {
    @NotNull
    private final Renderer source;
    private final float x;
    private final float y;
    private final float w;
    private final float h;

    public OffsetRendererX(@NotNull Renderer source, float x, float y, float w, float h) {
        this.source = source;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor compositor) {
        if (this.source instanceof BasicRendererRenderer) {
            BasicRendererRenderer brr = (BasicRendererRenderer)this.source;
            BasicRenderer r = brr.getBasicRenderer();
            RendererDescription rd = brr.getRendererDescription();
            if (rd.isTrivial()) {
                int scaleFactor = compositor.getScaleFactor();
                int rx = Math.round((float)scaleFactor * this.x);
                int ry = Math.round((float)scaleFactor * this.y);
                int rw = (int)Math.ceil((float)scaleFactor * this.w);
                int rh = (int)Math.ceil((float)scaleFactor * this.h);
                compositor.composeRenderer(r, rx, ry, rw, rh);
            } else {
                int scaleFactor = compositor.getScaleFactor();
                Rectangle2D.Float bounds = new Rectangle2D.Float(this.x, this.y, this.w, this.h);
                RasterDescription sd = rd.getRasterBounds(bounds, scaleFactor);
                int rx = Math.round((float)scaleFactor * sd.getX());
                int ry = Math.round((float)scaleFactor * sd.getY());
                int rw = (int)Math.ceil((float)scaleFactor * sd.getWidth());
                int rh = (int)Math.ceil((float)scaleFactor * sd.getHeight());
                compositor.composeRenderer(r, rx, ry, rw, rh);
            }
        } else if (this.source instanceof PainterExtensionRenderer) {
            PainterExtensionRenderer pxr = (PainterExtensionRenderer)this.source;
            PainterExtension px = pxr.getPainterExtension();
            int scaleFactor = compositor.getScaleFactor();
            int rx = Math.round((float)scaleFactor * this.x);
            int ry = Math.round((float)scaleFactor * this.y);
            int rw = (int)Math.ceil((float)scaleFactor * this.w);
            int rh = (int)Math.ceil((float)scaleFactor * this.h);
            compositor.composePainter(px, rx, ry, rw, rh);
        } else {
            int scaleFactor = compositor.getScaleFactor();
            int rx = Math.round((float)scaleFactor * this.x);
            int ry = Math.round((float)scaleFactor * this.y);
            ReusableCompositor temp = compositor.createSimilar(this.w, this.h);
            this.source.composeTo(temp);
            int rw = temp.getRasterWidth();
            int rh = temp.getRasterHeight();
            compositor.composeFrom(temp, rx, ry, rw, rh);
        }
    }
}

