/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AppearanceContext {
    @NotNull
    private final AquaAppearance appearance;
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isSelected;
    private final boolean isIcon;

    public AppearanceContext(@NotNull AquaAppearance aquaAppearance, @NotNull AquaUIPainter.State state, boolean bl, boolean bl2) {
        this.appearance = aquaAppearance;
        this.state = state;
        this.isSelected = bl;
        this.isIcon = bl2;
    }

    @NotNull
    public AquaAppearance getAppearance() {
        return this.appearance;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    @NotNull
    public AppearanceContext withSelected(boolean bl) {
        return bl == this.isSelected ? this : new AppearanceContext(this.appearance, this.state, bl, this.isIcon);
    }

    @NotNull
    public AppearanceContext withState(@NotNull AquaUIPainter.State state) {
        return state == this.state ? this : new AppearanceContext(this.appearance, state, this.isSelected, this.isIcon);
    }

    @NotNull
    public String toString() {
        String string = "[" + this.appearance.getName() + " " + this.state;
        if (this.isSelected) {
            string = string + " Selected";
        }
        if (this.isIcon) {
            string = string + " Icon";
        }
        return string + "]";
    }
}

