/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaButtonSupport;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaDisclosureButtonBorder;
import org.violetlib.aqua.AquaDisclosureTriangleButtonBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIconToggleButtonBorder;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaToggleButtonBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicAquaAppearance;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.VAquaRenderingAccess;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ColorWellButtonConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public abstract class AquaButtonBorder
extends AquaBorder
implements FocusRingOutlineProvider {
    @NotNull
    public static final String AQUA_EXCLUSIVE_BUTTON = "Aqua.Button.isExclusiveButton";
    public static final AquaUtils.RecyclableSingleton<AquaPushButtonBorder> fPush = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaPushButtonBorder>(AquaPushButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaToggleButtonBorder> fToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaToggleButtonBorder>(AquaToggleButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaIconToggleButtonBorder> fIconToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaIconToggleButtonBorder>(AquaIconToggleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureTriangleButtonBorder> fDisclosureTriangle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureTriangleButtonBorder>(AquaDisclosureTriangleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureButtonBorder> fDisclosure = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureButtonBorder>(AquaDisclosureButtonBorder.class);
    protected static final Dimension regularToolbarSize = new Dimension(32, 32);
    protected static final Dimension smallToolbarSize = new Dimension(24, 24);
    protected final AquaButtonIcon.ImageOperatorSupplier keySupplier = new MyImageOperatorSupplier();

    public static AquaButtonBorder getPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getIconToggleButtonBorder() {
        return fIconToggle.get();
    }

    public static AquaButtonBorder getToolBarPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToolBarToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getDisclosureTriangleButtonBorder() {
        return fDisclosureTriangle.get();
    }

    public static AquaButtonBorder getDisclosureButtonBorder() {
        return fDisclosure.get();
    }

    protected AquaButtonBorder() {
    }

    @Override
    public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintButton(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @Nullable Icon icon, @NotNull Rectangle rectangle) {
        GenericButtonConfiguration genericButtonConfiguration = this.getConfiguration(abstractButton, rectangle.width, rectangle.height);
        if (genericButtonConfiguration != null) {
            this.paintBackground(graphics2D, abstractButton, (Configuration)genericButtonConfiguration, rectangle);
            if (this.allowsContent()) {
                Dimension dimension = this.getIconSize((Configuration)genericButtonConfiguration);
                Color color = this.getForegroundColor(abstractButton, genericButtonConfiguration, false);
                Insets insets = this.getButtonContentInsets(abstractButton);
                AquaButtonUI.paintIconAndText(graphics2D, abstractButton, insets, icon, color, rectangle, dimension);
            }
        }
    }

    public void paintBackground(@NotNull Graphics2D graphics2D, @NotNull AbstractButton abstractButton, @NotNull Configuration configuration, @NotNull Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        AppearanceManager.ensureAppearance(abstractButton);
        AquaUtils.configure(this.painter, abstractButton, n3, n4);
        Painter painter = this.painter.getPainter(configuration);
        painter.paint((Graphics)graphics2D, (float)n, (float)n2);
        if (AquaButtonUI.isColorWell(abstractButton) && !"ColorWellButtonConfiguration".equals(configuration.getClass().getSimpleName())) {
            Object object;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            float f = 6.0f;
            float f2 = 6.0f;
            float f3 = (float)n + f2;
            float f4 = (float)n3 - 2.0f * f2;
            float f5 = f3 + f4;
            float f6 = (float)n2 + f;
            float f7 = (float)n4 - 2.0f * f;
            float f8 = f6 + f7;
            RectangularShape rectangularShape = OSXSystemProperties.OSVersion >= 1300 ? new RoundRectangle2D.Float(f3, f6, f4, f7, 4.0f, 4.0f) : new Rectangle2D.Float(f3, f6, f4, f7);
            Color color = abstractButton.getBackground();
            if (color.getAlpha() != 255) {
                graphics2D2.setColor(Color.BLACK);
                AquaUtils.fillAntiAliased(graphics2D2, rectangularShape);
                object = new Path2D.Float();
                ((Path2D.Float)object).moveTo(f3, f8);
                ((Path2D.Float)object).lineTo(f5, f6);
                ((Path2D.Float)object).lineTo(f5, f8);
                ((Path2D)object).closePath();
                graphics2D2.clip(rectangularShape);
                graphics2D2.setColor(Color.WHITE);
                AquaUtils.fillAntiAliased(graphics2D2, (Shape)object);
                graphics2D2.setClip(null);
            }
            graphics2D2.setColor(color);
            AquaUtils.fillAntiAliased(graphics2D2, rectangularShape);
            if (OSXSystemProperties.OSVersion >= 1300 && color.getAlpha() != 255) {
                object = AppearanceManager.ensureAppearance(abstractButton);
                graphics2D2.setColor(((BasicAquaAppearance)object).isDark() ? new Color(255, 255, 255, 52) : new Color(0, 0, 0, 52));
                AquaUtils.drawAntiAliased(graphics2D2, rectangularShape);
            }
            graphics2D2.dispose();
        }
    }

    @NotNull
    protected AquaUIPainter.State getState(@NotNull Configuration configuration) {
        if (configuration instanceof ButtonConfiguration) {
            ButtonConfiguration buttonConfiguration = (ButtonConfiguration)configuration;
            return buttonConfiguration.getState();
        }
        if (configuration instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration segmentedButtonConfiguration = (SegmentedButtonConfiguration)configuration;
            return segmentedButtonConfiguration.getState();
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @NotNull
    protected AquaUIPainter.State getState(@NotNull AbstractButton abstractButton) {
        boolean bl = AquaFocusHandler.isActive(abstractButton);
        if (!abstractButton.isEnabled()) {
            return bl ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!bl) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return AquaButtonSupport.getPressedState(abstractButton);
        }
        if (abstractButton.isRolloverEnabled() && this.isRollover(abstractButton)) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaButtonSupport.getActiveState(abstractButton);
    }

    protected boolean isRollover(@NotNull AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        return buttonModel.isRollover();
    }

    public boolean allowsContent() {
        return true;
    }

    public boolean isRolloverEnabled(AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        return widgetInfo.isRolloverEnabled();
    }

    @NotNull
    public Font getCustomDefaultFont(@NotNull AbstractButton abstractButton, @NotNull AquaUIPainter.Size size, @NotNull Font font) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration;
            AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
            return AquaButtonExtendedTypes.getFont(buttonWidget, size, font);
        }
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration) {
            SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = (SegmentedButtonLayoutConfiguration)layoutConfiguration;
            AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
            return AquaButtonExtendedTypes.getFont(segmentedButtonWidget, size, font);
        }
        return font;
    }

    @NotNull
    public Color getForegroundColor(@NotNull AbstractButton abstractButton, @NotNull GenericButtonConfiguration genericButtonConfiguration, boolean bl) {
        AquaUIPainter.State state = genericButtonConfiguration.getState();
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        boolean bl2 = abstractButton.getModel().isEnabled();
        boolean bl3 = this.shouldUseNonexclusiveStyle(abstractButton, widgetInfo);
        Color color = abstractButton.getForeground();
        if (color == null || color instanceof UIResource || !bl2 || bl3) {
            AquaUIPainter.ButtonState buttonState = this.getButtonState(abstractButton);
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
            if (state == AquaUIPainter.State.PRESSED_DEFAULT) {
                state = AquaUIPainter.State.ACTIVE_DEFAULT;
            } else if (OSXSystemProperties.OSVersion >= 1200 && state == AquaUIPainter.State.PRESSED) {
                state = AquaUIPainter.State.ACTIVE;
            }
            return widgetInfo.getForeground(state, buttonState, aquaAppearance, bl3, bl);
        }
        return color;
    }

    protected boolean shouldUseNonexclusiveStyle(@NotNull AbstractButton abstractButton, @NotNull AquaButtonExtendedTypes.WidgetInfo widgetInfo) {
        return widgetInfo.usesNonexclusiveSelectionStyle() && abstractButton.getModel().isSelected() && !this.isButtonExclusive(abstractButton);
    }

    protected boolean isButtonExclusive(@NotNull AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel instanceof DefaultButtonModel) {
            DefaultButtonModel defaultButtonModel = (DefaultButtonModel)buttonModel;
            return defaultButtonModel.getGroup() != null || Boolean.TRUE.equals(abstractButton.getClientProperty(AQUA_EXCLUSIVE_BUTTON));
        }
        return true;
    }

    public int getIconTextGap(AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        int n = widgetInfo.getIconTextGap();
        return n > 0 ? n : 4;
    }

    @Override
    public final Insets getBorderInsets(Component component) {
        if (!(component instanceof AbstractButton)) {
            return new Insets(0, 0, 0, 0);
        }
        AbstractButton abstractButton = (AbstractButton)component;
        Insetter insetter = this.getContentInsets(abstractButton);
        Insets insets = this.getMarginAdjustments(abstractButton);
        return AquaUtils.combineAsInsets(insetter, insets);
    }

    public final Insets2D getBorderInsets2D(Component component) {
        if (!(component instanceof AbstractButton)) {
            return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
        }
        AbstractButton abstractButton = (AbstractButton)component;
        Insetter insetter = this.getContentInsets(abstractButton);
        Insets insets = this.getMarginAdjustments(abstractButton);
        return AquaUtils.combineAsInsets2D(insetter, insets);
    }

    @Nullable
    protected Insets getMarginAdjustments(@NotNull AbstractButton abstractButton) {
        Insets insets = abstractButton.getMargin();
        if (insets != null && !(insets instanceof UIResource)) {
            return insets;
        }
        Insets insets2 = this.getSpecialMarginAdjustments(abstractButton);
        return insets2 != null ? insets2 : insets;
    }

    @Nullable
    protected Insets getSpecialMarginAdjustments(@NotNull AbstractButton abstractButton) {
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget;
        int n = this.getMargin(abstractButton);
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = n;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration && ((segmentedButtonWidget = (segmentedButtonLayoutConfiguration = (SegmentedButtonLayoutConfiguration)layoutConfiguration).getWidget()) == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB) && segmentedButtonLayoutConfiguration.getSize() == AquaUIPainter.Size.MINI) {
            n2 = 1;
        }
        return new Insets(n2, n3, n4, n5);
    }

    protected int getMargin(@NotNull AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        return widgetInfo.getMargin();
    }

    @Nullable
    protected Insetter getContentInsets(@NotNull AbstractButton abstractButton) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        return layoutConfiguration != null ? this.painter.getLayoutInfo().getContentInsets(layoutConfiguration) : null;
    }

    @NotNull
    public Insets getButtonContentInsets(@NotNull AbstractButton abstractButton) {
        Insets insets;
        Insetter insetter;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration != null && (insetter = this.painter.getLayoutInfo().getContentInsets(layoutConfiguration)) != null && (insets = insetter.asInsets()) != null) {
            return insets;
        }
        return abstractButton.getInsets();
    }

    @Nullable
    public AquaButtonIcon createIcon(@NotNull AbstractButton abstractButton, boolean bl) {
        return new AquaButtonIcon(abstractButton, bl, this.keySupplier);
    }

    protected boolean shouldUseDisabledIcon(@Nullable GenericButtonConfiguration genericButtonConfiguration, @NotNull AquaUIPainter.State state) {
        if (genericButtonConfiguration != null) {
            return this.shouldUseDisabledIcon(genericButtonConfiguration);
        }
        return state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE;
    }

    protected boolean shouldUseDisabledIcon(@NotNull GenericButtonConfiguration genericButtonConfiguration) {
        AquaUIPainter.State state = genericButtonConfiguration.getState();
        if (state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
            return true;
        }
        if (state == AquaUIPainter.State.INACTIVE && genericButtonConfiguration.isTextured()) {
            return OSXSystemProperties.OSVersion < 1015;
        }
        return false;
    }

    @NotNull
    public Dimension getPreferredButtonSize(@NotNull AbstractButton abstractButton) {
        Dimension dimension;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        Dimension dimension2 = this.getMinimumButtonSize(layoutConfiguration);
        Dimension dimension3 = null;
        if (layoutConfiguration != null) {
            dimension3 = this.getIconSize(layoutConfiguration);
        }
        if ((dimension = AquaButtonSupport.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap(), dimension3)) != null) {
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            }
            if (dimension.height > dimension2.height) {
                dimension2.height = dimension.height;
            }
        }
        return dimension2;
    }

    @NotNull
    private Dimension getMinimumButtonSize(@Nullable LayoutConfiguration layoutConfiguration) {
        Dimension dimension = new Dimension(10, 10);
        if (layoutConfiguration != null) {
            LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(layoutConfiguration);
            int n = (int)Math.ceil(layoutInfo.getMinimumVisualWidth());
            int n2 = (int)Math.ceil(layoutInfo.getMinimumVisualHeight());
            if (n > 0) {
                dimension.width = n;
            }
            if (n2 > 0) {
                dimension.height = n2;
            }
        }
        return dimension;
    }

    @Nullable
    protected Dimension getIconSize(@NotNull Configuration configuration) {
        if (configuration instanceof LayoutConfiguration) {
            return this.getIconSize((LayoutConfiguration)configuration);
        }
        return null;
    }

    @Nullable
    protected Dimension getIconSize(@NotNull LayoutConfiguration layoutConfiguration) {
        ButtonLayoutConfiguration buttonLayoutConfiguration;
        AquaUIPainter.ButtonWidget buttonWidget;
        if (layoutConfiguration instanceof ButtonLayoutConfiguration && (buttonWidget = (buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget()) == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
            switch (size) {
                case SMALL: 
                case MINI: {
                    return smallToolbarSize;
                }
            }
            return regularToolbarSize;
        }
        return null;
    }

    @NotNull
    protected AquaButtonExtendedTypes.WidgetInfo getWidgetInfo(@NotNull AbstractButton abstractButton) {
        AquaUIPainter.ButtonWidget buttonWidget = null;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            buttonWidget = ((ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget();
        }
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration) {
            buttonWidget = ((SegmentedButtonLayoutConfiguration)layoutConfiguration).getWidget();
        }
        return AquaButtonExtendedTypes.getWidgetInfo(buttonWidget);
    }

    protected boolean shouldUseIconicWidget(@NotNull AbstractButton abstractButton) {
        return OSXSystemProperties.OSVersion >= 1016 && AquaButtonBorder.isIconOnly(abstractButton);
    }

    public static boolean isIconOnly(@NotNull AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            return false;
        }
        String string = abstractButton.getText();
        return string == null || string.isEmpty();
    }

    @NotNull
    protected AquaUIPainter.ButtonWidget getIconicWidget(@NotNull AquaUIPainter.ButtonWidget buttonWidget) {
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR && VAquaRenderingAccess.BUTTON_TEXTURED_TOOLBAR_ICONS != null) {
            return VAquaRenderingAccess.BUTTON_TEXTURED_TOOLBAR_ICONS;
        }
        return buttonWidget;
    }

    @Nullable
    public GenericButtonConfiguration getConfiguration(@NotNull AbstractButton abstractButton, int n, int n2) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(abstractButton);
            boolean bl = this.computeIsFocused(state, abstractButton);
            AquaUIPainter.ButtonState buttonState = this.getButtonState(abstractButton);
            ButtonConfiguration buttonConfiguration = new ButtonConfiguration((ButtonLayoutConfiguration)layoutConfiguration, state, bl, buttonState);
            if (AquaButtonUI.isColorWell(abstractButton)) {
                try {
                    buttonConfiguration = new ColorWellButtonConfiguration(buttonConfiguration, abstractButton.getBackground());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return buttonConfiguration;
        }
        return null;
    }

    protected boolean computeIsFocused(@NotNull AquaUIPainter.State state, @NotNull AbstractButton abstractButton) {
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            return state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.INACTIVE && state != AquaUIPainter.State.DISABLED_INACTIVE;
        }
        return false;
    }

    public LayoutConfiguration getLayoutConfigurationForOutline(@NotNull AbstractButton abstractButton) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (abstractButton instanceof JToggleButton && layoutConfiguration instanceof ButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(abstractButton);
            boolean bl = this.computeIsFocused(state, abstractButton);
            AquaUIPainter.ButtonState buttonState = this.getButtonState(abstractButton);
            return new ButtonConfiguration((ButtonLayoutConfiguration)layoutConfiguration, state, bl, buttonState);
        }
        return layoutConfiguration;
    }

    @Nullable
    public LayoutConfiguration getLayoutConfiguration(@NotNull AbstractButton abstractButton) {
        return (LayoutConfiguration)abstractButton.getClientProperty("Aqua.Button.LayoutConfiguration");
    }

    @Nullable
    public LayoutConfiguration determineLayoutConfiguration(@NotNull AbstractButton abstractButton) {
        AquaUIPainter.GenericButtonWidget genericButtonWidget = this.getButtonWidget(abstractButton);
        AquaUIPainter.Size size = this.getSpecialDefaultSize(abstractButton);
        AquaUIPainter.Size size2 = AquaUtilControlSize.getUserSizeFrom(abstractButton, size);
        if (genericButtonWidget instanceof AquaUIPainter.ButtonWidget) {
            AquaUIPainter.ButtonWidget buttonWidget = (AquaUIPainter.ButtonWidget)genericButtonWidget;
            AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(abstractButton);
            if (this.shouldUseIconicWidget(abstractButton)) {
                buttonWidget = this.getIconicWidget(buttonWidget);
            }
            return new ButtonLayoutConfiguration(buttonWidget, size2, uILayoutDirection);
        }
        if (genericButtonWidget instanceof AquaUIPainter.SegmentedButtonWidget) {
            AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = (AquaUIPainter.SegmentedButtonWidget)genericButtonWidget;
            return new SegmentedButtonLayoutConfiguration(segmentedButtonWidget, size2, AquaUIPainter.Position.ONLY);
        }
        return null;
    }

    @NotNull
    public abstract AquaUIPainter.GenericButtonWidget getButtonWidget(@NotNull AbstractButton var1);

    @Nullable
    protected AquaUIPainter.Size getSpecialDefaultSize(@NotNull AbstractButton abstractButton) {
        if (OSXSystemProperties.OSVersion >= 1016) {
            boolean bl = AquaUtils.isOnToolbar(abstractButton);
            return bl ? AquaUIPainter.Size.LARGE : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfigurationForOutline((AbstractButton)jComponent);
        if (layoutConfiguration != null) {
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            AppearanceManager.ensureAppearance(jComponent);
            AquaUtils.configure(this.painter, jComponent, n, n2);
            return this.painter.getOutline(layoutConfiguration);
        }
        return null;
    }

    protected boolean isProposedButtonWidgetUsable(@NotNull AbstractButton abstractButton, @NotNull Object object) {
        Font font;
        ButtonLayoutConfiguration buttonLayoutConfiguration;
        AquaUIPainter.ButtonWidget buttonWidget;
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(abstractButton);
        if (object instanceof AquaUIPainter.ButtonWidget) {
            buttonWidget = (AquaUIPainter.ButtonWidget)object;
            AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(abstractButton);
            buttonLayoutConfiguration = new ButtonLayoutConfiguration(buttonWidget, size, uILayoutDirection);
        } else if (object instanceof AquaUIPainter.SegmentedButtonWidget) {
            buttonWidget = (AquaUIPainter.SegmentedButtonWidget)object;
            buttonLayoutConfiguration = new SegmentedButtonLayoutConfiguration((AquaUIPainter.SegmentedButtonWidget)buttonWidget, size, AquaUIPainter.Position.MIDDLE);
        } else {
            return false;
        }
        buttonWidget = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)buttonLayoutConfiguration);
        int n = (int)Math.ceil(buttonWidget.getFixedVisualHeight());
        if (n == 0) {
            return true;
        }
        Insetter insetter = this.painter.getLayoutInfo().getContentInsets((LayoutConfiguration)buttonLayoutConfiguration);
        if (insetter == null || !insetter.isInvertible()) {
            return true;
        }
        Font font2 = font = AquaUtilControlSize.isOKToInstallDefaultFont(abstractButton) ? AquaButtonExtendedTypes.getFont(object, size, AquaButtonBorder.getGenericDefaultFont(abstractButton)) : abstractButton.getFont();
        if (font == null) {
            return false;
        }
        Dimension dimension = AquaButtonSupport.getPreferredContentSize(abstractButton, font, abstractButton.getIconTextGap());
        Dimension dimension2 = insetter.expand(dimension);
        return dimension2.height <= n;
    }

    @NotNull
    private static Font getGenericDefaultFont(@NotNull AbstractButton abstractButton) {
        Font font = AquaButtonUI.getDefaultFontPropertyValue(abstractButton);
        if (font == null) {
            return new Font("Default", 0, 12);
        }
        return font;
    }

    @NotNull
    protected AquaUIPainter.ButtonState getButtonState(@NotNull AbstractButton abstractButton) {
        ButtonLayoutConfiguration buttonLayoutConfiguration;
        if (abstractButton instanceof JToggleButton && !(abstractButton instanceof JCheckBox) && !(abstractButton instanceof JRadioButton)) {
            return abstractButton.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration && (buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return abstractButton.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        return AquaUIPainter.ButtonState.STATELESS;
    }

    private class MyImageOperatorSupplier
    implements AquaButtonIcon.ImageOperatorSupplier {
        private MyImageOperatorSupplier() {
        }

        @Override
        @Nullable
        public Object getCurrentImageProcessingOperator(@NotNull AbstractButton abstractButton, boolean bl) {
            AquaUIPainter.State state;
            GenericButtonConfiguration genericButtonConfiguration = AquaButtonBorder.this.getConfiguration(abstractButton, abstractButton.getWidth(), abstractButton.getHeight());
            if (bl && genericButtonConfiguration != null) {
                return AquaButtonBorder.this.getForegroundColor(abstractButton, genericButtonConfiguration, true);
            }
            AquaUIPainter.State state2 = state = genericButtonConfiguration != null ? genericButtonConfiguration.getState() : AquaButtonBorder.this.getState(abstractButton);
            if (state == AquaUIPainter.State.PRESSED) {
                AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
                return aquaAppearance.isDark() ? AquaImageFactory.LIGHTEN_FOR_DISABLED : AquaImageFactory.DARKEN_FOR_PRESSED;
            }
            if (AquaButtonBorder.this.shouldUseDisabledIcon(genericButtonConfiguration, state)) {
                AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
                return aquaAppearance.isDark() ? AquaImageFactory.DARKEN_FOR_PRESSED : AquaImageFactory.LIGHTEN_FOR_DISABLED;
            }
            return null;
        }
    }
}

