/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaComboBoxPopupMenuUI;
import org.violetlib.aqua.AquaComboBoxType;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;

class AquaComboBoxPopup
extends BasicComboPopup
implements AquaExtendedPopup,
ListDataListener {
    protected static final String uiClassID = "ComboBoxPopupMenuUI";
    protected PopupDisplayType currentDisplayType;
    protected static MouseWheelListener mouseWheelEventConsumer = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            mouseWheelEvent.consume();
        }
    };

    public AquaComboBoxPopup(JComboBox<Object> jComboBox) {
        super(jComboBox);
    }

    public AquaComboBoxType getComboBoxType() {
        return this.comboBox != null ? AquaComboBoxUI.getComboBoxType(this.comboBox) : null;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected ListDataListener createListDataListener() {
        return this;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.possiblyUpdatePopup();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.possiblyUpdatePopup();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
        this.updateContents(false);
        this.putClientProperty("apple.awt._windowFadeOut", 150);
    }

    @Override
    protected JScrollPane createScroller() {
        JScrollPane jScrollPane = super.createScroller();
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        return jScrollPane;
    }

    private void possiblyUpdatePopup() {
        Rectangle rectangle = this.adjustPopupAndGetBounds(false);
        this.list.setSize(rectangle.width, rectangle.height);
        this.pack();
    }

    public void updateContents(boolean bl) {
        if (this.list != null) {
            AquaComboBoxPopupMenuUI aquaComboBoxPopupMenuUI;
            if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
                this.remove(this.list);
                if (bl) {
                    this.remove(this.scroller);
                }
                this.add(this.scroller);
                this.scroller.setViewportView(this.list);
            } else {
                this.remove(this.scroller);
                if (bl) {
                    this.remove(this.list);
                }
                this.add(this.list);
            }
            this.list.removeMouseWheelListener(mouseWheelEventConsumer);
            if (this.currentDisplayType == PopupDisplayType.EDITABLE_NO_SCROLL) {
                this.list.addMouseWheelListener(mouseWheelEventConsumer);
            }
            if (bl && (aquaComboBoxPopupMenuUI = AquaUtils.getUI(this, AquaComboBoxPopupMenuUI.class)) != null) {
                aquaComboBoxPopupMenuUI.configure(this.comboBox, this.list);
            }
        }
        this.setBorder(null);
    }

    protected Dimension getBestPopupSizeForRowCount(int n) {
        int n2 = this.comboBox.getModel().getSize();
        int n3 = this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL ? Math.min(n, n2) : n2;
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        for (int i = 0; i < n3; ++i) {
            Object e = this.list.getModel().getElementAt(i);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
            Dimension dimension2 = component.getPreferredSize();
            dimension.height += dimension2.height;
            dimension.width = Math.max(dimension2.width, dimension.width);
        }
        return dimension;
    }

    @NotNull
    protected PopupDisplayType computePopupDisplayType() {
        if (this.comboBox.isEditable()) {
            return this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount() ? PopupDisplayType.EDITABLE_SCROLL : PopupDisplayType.EDITABLE_NO_SCROLL;
        }
        return PopupDisplayType.CONTEXTUAL;
    }

    @Override
    public void show() {
        int n = this.comboBox.getItemCount();
        Rectangle rectangle = this.adjustPopupAndGetBounds(true);
        if (rectangle == null) {
            return;
        }
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.show(this.comboBox, rectangle.x, rectangle.y);
        int n2 = this.comboBox.getItemCount();
        if (n2 == 0) {
            this.hide();
            return;
        }
        if (n != n2) {
            Rectangle rectangle2 = this.adjustPopupAndGetBounds(false);
            this.list.setSize(rectangle2.width, rectangle2.height);
            this.pack();
            Point point = this.comboBox.getLocationOnScreen();
            this.setLocation(point.x + rectangle2.x, point.y + rectangle2.y);
        }
        this.list.requestFocusInWindow();
    }

    @Override
    protected JList<Object> createList() {
        ListCellRenderer<Object> listCellRenderer = null;
        AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class);
        if (aquaComboBoxUI != null) {
            listCellRenderer = aquaComboBoxUI.getListCellRenderer();
        }
        return new AquaPopupMenuList(this.comboBox.getModel(), listCellRenderer);
    }

    protected Rectangle adjustPopupAndGetBounds(boolean bl) {
        PopupDisplayType popupDisplayType = this.computePopupDisplayType();
        if (this.currentDisplayType != popupDisplayType) {
            this.currentDisplayType = popupDisplayType;
            this.updateContents(true);
        } else if (bl) {
            this.updateContents(true);
        }
        Dimension dimension = this.getBestPopupSizeForRowCount(this.comboBox.getMaximumRowCount());
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            this.scroller.setMaximumSize(dimension2);
            this.scroller.setPreferredSize(dimension2);
            this.scroller.setMinimumSize(dimension2);
            this.list.setMaximumSize(null);
            this.list.setPreferredSize(null);
            this.list.setMinimumSize(null);
        } else {
            this.list.setMaximumSize(dimension2);
            this.list.setPreferredSize(dimension2);
            this.list.setMinimumSize(dimension2);
        }
        this.list.invalidate();
        this.initializeListSelection();
        int n = this.comboBox.getSelectedIndex();
        if (n >= 0 && this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            Rectangle rectangle2 = this.list.getCellBounds(n, n);
            this.scroller.getViewport().setViewPosition(rectangle2.getLocation());
        }
        return rectangle;
    }

    protected void initializeListSelection() {
        AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class);
        if (aquaComboBoxUI != null && aquaComboBoxUI.updateListSelectionFromEditor()) {
            return;
        }
        int n = this.comboBox.getSelectedIndex();
        if (n == -1 || this.getComboBoxType() == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
        }
    }

    @Override
    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        int n5;
        Point point;
        AquaComboBoxUI aquaComboBoxUI;
        Point point2 = AquaUtils.getScreenLocation(this.comboBox);
        Rectangle rectangle = AquaUtils.getScreenBounds(point2, this.comboBox);
        if (this.currentDisplayType == PopupDisplayType.EDITABLE_SCROLL) {
            n3 += 15;
        }
        Insets insets = this.comboBox.getInsets();
        Dimension dimension = this.comboBox.getSize();
        int n6 = dimension.width - (insets.left + insets.right);
        n3 = Math.max(n6, n3);
        int n7 = point2.x + insets.left;
        if (!AquaUtils.isLeftToRight(this.comboBox)) {
            n7 = point2.x + dimension.width - insets.right - n3;
        }
        AquaComboBoxType aquaComboBoxType = this.getComboBoxType();
        int n8 = this.getNominalPopupYOffset();
        int n9 = point2.y + n8;
        int n10 = 0;
        if (aquaComboBoxType == AquaComboBoxType.POP_UP_MENU_BUTTON && (aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class)) != null && (point = aquaComboBoxUI.getPopupButtonLabelOffset()) != null) {
            n7 += point.x;
            n10 = point.y;
        }
        n9 += n10;
        this.putClientProperty("Aqua.PopupMenu.SelectedRegion", null);
        this.putClientProperty("Aqua.PopupMenu.SelectedRegionLocation", null);
        int n11 = 0;
        int n12 = rectangle.y + rectangle.height - point2.y;
        if (n12 < 100) {
            n5 = 4;
            int n13 = point2.y - n5;
            n9 = Math.max(rectangle.y, n13 - n4);
            n11 = n13 - n9;
        }
        if (this.list != null && aquaComboBoxType == AquaComboBoxType.POP_UP_MENU_BUTTON && (n5 = this.comboBox.getSelectedIndex()) >= 0) {
            Rectangle rectangle2 = this.list.getCellBounds(n5, n5);
            rectangle2 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height + 2);
            Point point3 = new Point(n7, point2.y + n10);
            this.putClientProperty("Aqua.PopupMenu.SelectedRegion", rectangle2);
            this.putClientProperty("Aqua.PopupMenu.SelectedRegionLocation", point3);
        }
        if (this.list != null && aquaComboBoxType == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            this.list.clearSelection();
        }
        this.putClientProperty("Aqua.PopupMenu.ScreenBounds", new Rectangle(n7, n9, 0, n11));
        return new Rectangle(n7 - point2.x, n9 - point2.y, n3, n4);
    }

    protected int getNominalPopupYOffset() {
        AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class);
        if (aquaComboBoxUI != null) {
            return aquaComboBoxUI.getNominalPopupYOffset();
        }
        return this.comboBox.getHeight() + 2;
    }

    @Override
    public void startArrowScroll() {
        if (this.list != null) {
            this.list.clearSelection();
        }
    }

    @Override
    public void stopArrowScroll() {
        Point point;
        if (this.list != null && (point = MouseInfo.getPointerInfo().getLocation()) != null) {
            SwingUtilities.convertPointFromScreen(point, this.list);
            int n = this.list.locationToIndex(point);
            if (n >= 0 && this.list.getSelectedIndex() != n) {
                this.list.setSelectedIndex(n);
            }
        }
    }

    @Override
    public void updateSelection(MouseEvent mouseEvent) {
        this.updateListBoxSelectionForEvent(mouseEvent, false);
    }

    @Override
    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        AquaComboBoxType aquaComboBoxType = this.getComboBoxType();
        if (aquaComboBoxType != AquaComboBoxType.EDITABLE_COMBO_BOX || mouseEvent.getID() == 506) {
            super.updateListBoxSelectionForEvent(mouseEvent, bl);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new AquaComboBoxPopupMouseListener();
    }

    protected boolean isTextured() {
        AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(this.comboBox, AquaComboBoxUI.class);
        return aquaComboBoxUI != null && aquaComboBoxUI.isTextured;
    }

    public static enum PopupDisplayType {
        EDITABLE_NO_SCROLL,
        EDITABLE_SCROLL,
        CONTEXTUAL;

    }

    protected static class AquaPopupMenuList
    extends JList<Object> {
        private boolean isRendererConfigured;

        public AquaPopupMenuList(ListModel<Object> listModel, @Nullable ListCellRenderer<Object> listCellRenderer) {
            super(listModel);
            this.setOpaque(false);
            boolean bl = this.isRendererConfigured = listCellRenderer != null;
            if (listCellRenderer != null) {
                super.setCellRenderer(listCellRenderer);
            }
        }

        @Override
        public void setCellRenderer(ListCellRenderer<? super Object> listCellRenderer) {
            if (!this.isRendererConfigured) {
                super.setCellRenderer(listCellRenderer);
            }
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isMetaDown()) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 4, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
            }
            super.processMouseEvent(mouseEvent);
        }
    }

    protected class AquaComboBoxPopupMouseListener
    extends MouseAdapter
    implements MouseListener {
        protected AquaComboBoxPopupMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == AquaComboBoxPopup.this.list) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || !AquaComboBoxPopup.this.comboBox.isEnabled()) {
                return;
            }
            if (AquaComboBoxPopup.this.comboBox.isEditable()) {
                Component component = AquaComboBoxPopup.this.comboBox.getEditor().getEditorComponent();
                if (this.shouldFocusEditor(component)) {
                    JavaSupport.requestFocusInWindowFromMouseEvent(component);
                }
            } else if (AquaComboBoxPopup.this.comboBox.isRequestFocusEnabled()) {
                JavaSupport.requestFocusInWindowFromMouseEvent(AquaComboBoxPopup.this.comboBox);
            }
            AquaComboBoxPopup.this.togglePopup();
        }

        protected boolean shouldFocusEditor(@NotNull Component component) {
            JComponent jComponent;
            if (component instanceof JComponent && !(jComponent = (JComponent)component).isRequestFocusEnabled()) {
                return false;
            }
            return !AquaComboBoxPopup.this.isTextured();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == AquaComboBoxPopup.this.list) {
                if (AquaComboBoxPopup.this.list.getModel().getSize() > 0) {
                    if (AquaComboBoxPopup.this.comboBox.getSelectedIndex() == AquaComboBoxPopup.this.list.getSelectedIndex()) {
                        AquaComboBoxPopup.this.comboBox.getEditor().setItem(AquaComboBoxPopup.this.list.getSelectedValue());
                    }
                    AquaComboBoxPopup.this.comboBox.setSelectedIndex(AquaComboBoxPopup.this.list.getSelectedIndex());
                }
                AquaComboBoxPopup.this.comboBox.setPopupVisible(false);
                if (AquaComboBoxPopup.this.comboBox.isEditable() && AquaComboBoxPopup.this.comboBox.getEditor() != null) {
                    AquaComboBoxPopup.this.comboBox.configureEditor(AquaComboBoxPopup.this.comboBox.getEditor(), AquaComboBoxPopup.this.comboBox.getSelectedItem());
                }
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = AquaComboBoxPopup.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                AquaComboBoxPopup.this.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    if (AquaComboBoxPopup.this.comboBox.getSelectedIndex() == AquaComboBoxPopup.this.list.getSelectedIndex()) {
                        AquaComboBoxPopup.this.comboBox.getEditor().setItem(AquaComboBoxPopup.this.list.getSelectedValue());
                    }
                    AquaComboBoxPopup.this.comboBox.setSelectedIndex(AquaComboBoxPopup.this.list.getSelectedIndex());
                }
                AquaComboBoxPopup.this.comboBox.setPopupVisible(false);
            }
            AquaComboBoxPopup.this.hasEntered = false;
            AquaComboBoxPopup.this.stopAutoScrolling();
        }
    }
}

