/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.ContextualColor;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.Utils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaContextualColorImpl
implements ContextualColor {
    @NotNull
    protected final String colorName;
    @NotNull
    protected String basicName;
    @Nullable
    protected String rolloverName;
    @Nullable
    protected String pressedName;
    @Nullable
    protected String iconPressedName;
    @Nullable
    protected String inactiveName;
    @Nullable
    protected String disabledName;
    @Nullable
    protected String inactiveDisabledName;
    @Nullable
    protected String activeDefaultName;
    @Nullable
    protected String selectedName;
    @Nullable
    protected String pressedSelectedName;
    @Nullable
    protected String rolloverSelectedName;
    @Nullable
    protected String inactiveSelectedName;
    @Nullable
    protected String disabledSelectedName;
    @Nullable
    protected String inactiveDisabledSelectedName;
    @Nullable
    protected String activeDefaultSelectedName;

    public AquaContextualColorImpl(@NotNull String string, @NotNull String string2) {
        this.colorName = string;
        this.basicName = string2;
    }

    @Override
    @NotNull
    public String getColorName() {
        return this.colorName;
    }

    @NotNull
    public String getBasicName() {
        return this.basicName;
    }

    public void setBasicName(@NotNull String string) {
        this.basicName = string;
    }

    public void setAllNames() {
        this.setAllNames(this.basicName);
    }

    public void setAllNames(@NotNull String string) {
        this.basicName = string;
        this.rolloverName = string + "_rollover";
        this.pressedName = string + "_pressed";
        this.inactiveName = string + "_inactive";
        this.disabledName = string + "_disabled";
        this.inactiveDisabledName = string + "_inactive_disabled";
        this.activeDefaultName = string + "_focused";
        String string2 = AquaColors.createSelectedColorName(this.basicName);
        this.setAllSelectedNames(string2);
    }

    public void setAllSelectedNames(@NotNull String string) {
        this.selectedName = string;
        this.pressedSelectedName = string + "_pressed";
        this.rolloverSelectedName = string + "_rollover";
        this.inactiveSelectedName = string + "_inactive";
        this.disabledSelectedName = string + "_disabled";
        this.inactiveDisabledSelectedName = string + "_inactive_disabled";
        this.activeDefaultSelectedName = string + "_focused";
    }

    @Nullable
    public String getRolloverName() {
        return this.rolloverName;
    }

    public void setRolloverName(@Nullable String string) {
        this.rolloverName = string;
    }

    @Nullable
    public String getIconPressedName() {
        return this.iconPressedName;
    }

    public void setIconPressedName(@Nullable String string) {
        this.iconPressedName = string;
    }

    @Nullable
    public String getPressedSelectedName() {
        return this.pressedSelectedName;
    }

    public void setPressedSelectedName(@Nullable String string) {
        this.pressedSelectedName = string;
    }

    @Nullable
    public String getRolloverSelectedName() {
        return this.rolloverSelectedName;
    }

    public void setRolloverSelectedName(@Nullable String string) {
        this.rolloverSelectedName = string;
    }

    @Nullable
    public String getPressedName() {
        return this.pressedName;
    }

    public void setPressedName(@Nullable String string) {
        this.pressedName = string;
    }

    @Nullable
    public String getInactiveDisabledSelectedName() {
        return this.inactiveDisabledSelectedName;
    }

    public void setInactiveDisabledSelectedName(@Nullable String string) {
        this.inactiveDisabledSelectedName = string;
    }

    @Nullable
    public String getInactiveDisabledName() {
        return this.inactiveDisabledName;
    }

    public void setInactiveDisabledName(@Nullable String string) {
        this.inactiveDisabledName = string;
    }

    @Nullable
    public String getDisabledSelectedName() {
        return this.disabledSelectedName;
    }

    public void setDisabledSelectedName(@Nullable String string) {
        this.disabledSelectedName = string;
    }

    @Nullable
    public String getDisabledName() {
        return this.disabledName;
    }

    public void setDisabledName(@Nullable String string) {
        this.disabledName = string;
    }

    @Nullable
    public String getInactiveSelectedName() {
        return this.inactiveSelectedName;
    }

    public void setInactiveSelectedName(@Nullable String string) {
        this.inactiveSelectedName = string;
    }

    @Nullable
    public String getInactiveName() {
        return this.inactiveName;
    }

    public void setInactiveName(@Nullable String string) {
        this.inactiveName = string;
    }

    @Nullable
    public String getSelectedName() {
        return this.selectedName;
    }

    public void setSelectedName(@Nullable String string) {
        this.selectedName = string;
    }

    @Nullable
    public String getActiveDefaultName() {
        return this.activeDefaultName;
    }

    public void setActiveDefaultName(@Nullable String string) {
        this.activeDefaultName = string;
    }

    @Nullable
    public String getActiveDefaultSelectedName() {
        return this.activeDefaultSelectedName;
    }

    public void setActiveDefaultSelectedName(@Nullable String string) {
        this.activeDefaultSelectedName = string;
    }

    @Override
    @NotNull
    public Color get(@NotNull AppearanceContext appearanceContext) {
        Object object;
        Object object2;
        AquaAppearance aquaAppearance = appearanceContext.getAppearance();
        AquaUIPainter.State state = appearanceContext.getState();
        boolean bl = appearanceContext.isSelected();
        boolean bl2 = appearanceContext.isIcon();
        if (AquaColors.isDebugging()) {
            object2 = this.getColorName();
            object = (String)object2 + ": lookup color for " + aquaAppearance.getName() + " " + state;
            if (bl) {
                object = (String)object + " SELECTED";
            }
            if (bl2) {
                object = (String)object + " ICON";
            }
            Utils.logDebug((String)object);
        }
        if (state == AquaUIPainter.State.ROLLOVER) {
            if (bl && this.rolloverSelectedName != null && (object2 = aquaAppearance.getColor(this.rolloverSelectedName)) != null) {
                return object2;
            }
            if (this.rolloverName != null && (object2 = aquaAppearance.getColor(this.rolloverName)) != null) {
                return object2;
            }
            object2 = aquaAppearance.getColorForEffect(this.basicName, EffectName.EFFECT_ROLLOVER);
            if (object2 != null) {
                return object2;
            }
        }
        if (state == AquaUIPainter.State.PRESSED) {
            if (bl2 && this.iconPressedName != null && (object2 = aquaAppearance.getColor(this.iconPressedName)) != null) {
                return object2;
            }
            if (bl && this.pressedSelectedName != null && (object2 = aquaAppearance.getColor(this.pressedSelectedName)) != null) {
                return object2;
            }
            if (this.pressedName != null && (object2 = aquaAppearance.getColor(this.pressedName)) != null) {
                return object2;
            }
            object2 = aquaAppearance.getColorForEffect(this.basicName, EffectName.EFFECT_PRESSED);
            if (object2 != null) {
                return object2;
            }
        }
        if (state == AquaUIPainter.State.DISABLED_INACTIVE) {
            if (bl && this.inactiveDisabledSelectedName != null && (object2 = aquaAppearance.getColor(this.inactiveDisabledSelectedName)) != null) {
                return object2;
            }
            if (this.inactiveDisabledName != null && (object2 = aquaAppearance.getColor(this.inactiveDisabledName)) != null) {
                return object2;
            }
            object2 = this.basicName + "_inactive_disabled";
            object = aquaAppearance.getColor((String)object2);
            if (object != null) {
                return object;
            }
            state = AquaUIPainter.State.DISABLED;
        }
        if (state == AquaUIPainter.State.DISABLED) {
            if (bl) {
                if (this.disabledSelectedName != null && (object2 = aquaAppearance.getColor(this.disabledSelectedName)) != null) {
                    return object2;
                }
                if (this.selectedName != null && (object2 = aquaAppearance.getColorForEffect(this.selectedName, EffectName.EFFECT_DISABLED)) != null) {
                    return object2;
                }
            }
            if (this.disabledName != null && (object2 = aquaAppearance.getColor(this.disabledName)) != null) {
                return object2;
            }
            object2 = aquaAppearance.getColorForEffect(this.basicName, EffectName.EFFECT_DISABLED);
            if (object2 != null) {
                return object2;
            }
            state = AquaUIPainter.State.INACTIVE;
        }
        if (state == AquaUIPainter.State.INACTIVE) {
            if (bl) {
                if (this.inactiveSelectedName != null && (object2 = aquaAppearance.getColor(this.inactiveSelectedName)) != null) {
                    return object2;
                }
                if (this.selectedName != null && (object2 = aquaAppearance.getColorForEffect(this.selectedName, EffectName.EFFECT_DISABLED)) != null) {
                    return object2;
                }
            }
            if (this.inactiveName != null && (object2 = aquaAppearance.getColor(this.inactiveName)) != null) {
                return object2;
            }
            object2 = aquaAppearance.getColorForEffect(this.basicName, EffectName.EFFECT_DISABLED);
            if (object2 != null) {
                return object2;
            }
        }
        if (state == AquaUIPainter.State.ACTIVE_DEFAULT) {
            if (bl && this.activeDefaultSelectedName != null && (object2 = aquaAppearance.getColor(this.activeDefaultSelectedName)) != null) {
                return object2;
            }
            if (this.activeDefaultName != null && (object2 = aquaAppearance.getColor(this.activeDefaultName)) != null) {
                return object2;
            }
        }
        if (bl && this.selectedName != null && (object2 = aquaAppearance.getColor(this.selectedName)) != null) {
            return object2;
        }
        object2 = aquaAppearance.getColor(this.basicName);
        if (object2 != null) {
            return object2;
        }
        throw new UnsupportedOperationException("No color defined for: " + this.basicName);
    }
}

