/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;

public class AquaGroupBorder
extends AquaBorder {
    static final AquaUtils.RecyclableSingletonFromDefaultConstructor<? extends Border> tabbedPaneGroupBorder = new AquaUtils.RecyclableSingletonFromDefaultConstructor<TabbedPane>(TabbedPane.class);
    static final AquaUtils.RecyclableSingletonFromDefaultConstructor<? extends Border> titleBorderGroupBorder = new AquaUtils.RecyclableSingletonFromDefaultConstructor<Titled>(Titled.class);
    static final AquaUtils.RecyclableSingletonFromDefaultConstructor<? extends Border> titlelessGroupBorder = new AquaUtils.RecyclableSingletonFromDefaultConstructor<Titleless>(Titleless.class);
    @NotNull
    protected final Insets boxInsets;
    @NotNull
    protected final Insets borderInsets;
    protected final boolean isFrameOnly;

    public static Border getTabbedPaneGroupBorder() {
        return (Border)tabbedPaneGroupBorder.get();
    }

    public static Border getBorderForTitledBorder() {
        return (Border)titleBorderGroupBorder.get();
    }

    public static Border getTitlelessBorder() {
        return (Border)titlelessGroupBorder.get();
    }

    public AquaGroupBorder(@NotNull Insets insets, @NotNull Insets insets2, boolean bl) {
        this.boxInsets = insets;
        this.borderInsets = new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
        this.isFrameOnly = bl;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return (Insets)this.borderInsets.clone();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        AppearanceManager.ensureAppearance(component);
        AquaUtils.configure(this.painter, component, n3 -= this.boxInsets.left + this.boxInsets.right, n4 -= this.boxInsets.top + this.boxInsets.bottom);
        Configuration configuration = this.getConfiguration();
        this.painter.getPainter(configuration).paint(graphics, (float)(n += this.boxInsets.left), (float)(n2 += this.boxInsets.top));
    }

    protected Configuration getConfiguration() {
        return new GroupBoxConfiguration(AquaUIPainter.State.ACTIVE, this.isFrameOnly);
    }

    protected static class TabbedPane
    extends AquaGroupBorder {
        public TabbedPane() {
            super(new Insets(5, 5, 5, 5), new Insets(3, 7, 3, 7), false);
        }
    }

    protected static class Titled
    extends AquaGroupBorder {
        public Titled() {
            super(new Insets(0, 5, 4, 5), new Insets(8, 10, 8, 10), false);
        }
    }

    protected static class Titleless
    extends AquaGroupBorder {
        public Titleless() {
            super(new Insets(3, 5, 1, 5), new Insets(5, 7, 7, 7), false);
        }
    }
}

