/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.aqua.Utils;
import org.violetlib.jnr.Painter;

public class AquaIcon {
    public static final IconImageCreator alertCautionImageCreator = new IconImageCreator("caut", 64);
    public static final IconImageCreator alertStopImageCreator = new IconImageCreator("stop", 64);
    public static final IconImageCreator openFolderImageCreator = new IconImageCreator("ofld", 20);
    private static final RecyclableIconImageSingleton cautionIcon = new RecyclableIconImageSingleton(alertCautionImageCreator);
    private static final RecyclableIconImageSingleton stopIcon = new RecyclableIconImageSingleton(alertStopImageCreator);
    private static final RecyclableIconImageSingleton openFolderIcon = new RecyclableIconImageSingleton(openFolderImageCreator);
    private static final IconResourceLoader browserExpandArrowLoader = new IconResourceLoader("fc/ExpandArrowTemplate.png");

    @Nullable
    public static Image getImageForIcon(@Nullable Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    @NotNull
    public static Icon createPressedDarkIcon(@NotNull Icon icon) {
        Image image = AquaIcon.getImageForIcon(icon);
        if (image != null) {
            Image image2 = AquaImageFactory.getProcessedImage(image, AquaImageFactory.DARKEN_FOR_PRESSED);
            return new ImageIcon(image2);
        }
        return icon;
    }

    @NotNull
    public static Icon createDisabledLightIcon(@NotNull Icon icon) {
        Image image = AquaIcon.getImageForIcon(icon);
        if (image != null) {
            Image image2 = AquaImageFactory.getProcessedImage(image, AquaImageFactory.LIGHTEN_FOR_DISABLED);
            return new ImageIcon(image2);
        }
        return icon;
    }

    public static Image getStopIconImage() {
        return stopIcon.getInstance();
    }

    public static Image getCautionIconImage() {
        return cautionIcon.getInstance();
    }

    public static ImageIconUIResource getOpenFolderIcon() {
        return new ImageIconUIResource(openFolderIcon.getInstance());
    }

    @NotNull
    public static ImageIcon getBrowserExpandArrowTemplate() {
        return browserExpandArrowLoader.getIcon();
    }

    public static int OSTypeToInt(String string) {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n2 = string.length();
        if (n2 > 0) {
            if (n2 > 4) {
                n2 = 4;
            }
            string.getBytes(0, n2, byArray, 4 - n2);
        }
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n <<= 8;
            }
            n |= byArray[i] & 0xFF;
        }
        return n;
    }

    private static native boolean nativeRenderIcon(int var0, int[][] var1, int var2);

    private static class RecyclableIconImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final IconImageCreator imageCreator;

        public RecyclableIconImageSingleton(IconImageCreator iconImageCreator) {
            this.imageCreator = iconImageCreator;
        }

        @Override
        protected Image getInstance() {
            return this.imageCreator.getImage();
        }
    }

    private static class IconResourceLoader {
        @NotNull
        private final String resourceName;
        @Nullable
        private ImageIcon result;

        public IconResourceLoader(@NotNull String string) {
            this.resourceName = string;
        }

        @NotNull
        public ImageIcon getIcon() {
            if (this.result == null) {
                this.result = AquaImageFactory.loadResource(this.resourceName);
                if (this.result == null) {
                    throw new UnsupportedOperationException("Missing icon resource: " + this.resourceName);
                }
            }
            return this.result;
        }
    }

    private static class IconImageCreator {
        private final String osTypeName;
        private final int osType;
        private final int size;
        private Image result;

        public IconImageCreator(String string, int n) {
            this.osTypeName = string;
            this.osType = AquaIcon.OSTypeToInt(string);
            this.size = n;
        }

        public Image getImage() {
            if (this.result == null) {
                AquaNativeSupport.load();
                int[][] nArrayArray = new int[2][];
                if (!AquaIcon.nativeRenderIcon(this.osType, nArrayArray, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        Utils.logDebug("Failed to render image for icon " + this.osTypeName);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    Utils.logDebug("Rendered image for icon " + this.osTypeName);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, nArrayArray[0], nArrayArray[1]);
            }
            return this.result;
        }
    }

    public static abstract class ScalingNativeRenderedIcon
    implements Icon,
    UIResource {
        protected final int width;
        protected final int height;

        public ScalingNativeRenderedIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Painter painter = this.getPainter(this.width, this.height);
            graphics.clipRect(n, n2, this.width, this.height);
            painter.paint(graphics, (float)n, (float)n2);
            graphics.dispose();
        }

        public abstract Painter getPainter(int var1, int var2);

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public static abstract class CachingScalingIcon
    implements Icon,
    UIResource {
        int width;
        int height;
        Image image;

        public CachingScalingIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.image = null;
        }

        @Nullable
        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.image = this.createImage();
            }
            return this.image;
        }

        abstract Image createImage();

        public boolean hasIconRef() {
            return this.getImage() != null;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((image = this.getImage()) != null) {
                graphics.drawImage(image, n, n2, this.getIconWidth(), this.getIconHeight(), null);
            }
            graphics.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

