/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.OverlayScrollPaneHack;

public class AquaScrollBar
extends JScrollBar
implements UIResource {
    private int defaultUnitIncrement;
    private boolean unitIncrementSet;
    private boolean blockIncrementSet;

    public AquaScrollBar(int n, int n2) {
        super(n);
        this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        this.defaultUnitIncrement = n2;
    }

    @Override
    public void setUnitIncrement(int n) {
        this.unitIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setUnitIncrement(n);
    }

    @Override
    public int getUnitIncrement(int n) {
        if (this.unitIncrementSet) {
            return super.getUnitIncrement(n);
        }
        return this.defaultUnitIncrement;
    }

    @Override
    public void setBlockIncrement(int n) {
        this.blockIncrementSet = true;
        this.putClientProperty("JScrollBar.fastWheelScrolling", null);
        super.setBlockIncrement(n);
    }

    @Override
    public int getBlockIncrement(int n) {
        if (this.blockIncrementSet) {
            return super.getBlockIncrement(n);
        }
        JViewport jViewport = this.getViewport();
        if (jViewport == null) {
            return super.getBlockIncrement(n);
        }
        if (jViewport.getView() instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)jViewport.getView());
            Rectangle rectangle = jViewport.getViewRect();
            return scrollable.getScrollableBlockIncrement(rectangle, this.getOrientation(), n);
        }
        if (this.getOrientation() == 1) {
            return jViewport.getExtentSize().height;
        }
        return jViewport.getExtentSize().width;
    }

    @Nullable
    private JViewport getViewport() {
        JScrollPane jScrollPane = this.getScrollPane();
        return jScrollPane != null ? jScrollPane.getViewport() : null;
    }

    @Nullable
    private JScrollPane getScrollPane() {
        Container container = this.getParent();
        if (container instanceof OverlayScrollPaneHack.AquaOverlayViewportHolder) {
            container = container.getParent();
        }
        if (container instanceof JScrollPane) {
            return (JScrollPane)container;
        }
        return null;
    }
}

