/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FileChooserUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.Utils;

public class AquaSheetSupport {
    public static boolean isDebug = false;
    @NotNull
    public static final String FILE_CHOOSER_SHEET_KEY = "Aqua.fileChooserIsSheet";
    @NotNull
    public static final String IS_SHEET_KEY = "Aqua.isSheet";

    public static void showOptionPaneAsSheet(JDialog jDialog, final JOptionPane jOptionPane, final Consumer<Integer> consumer) throws UnsupportedOperationException {
        Runnable runnable = null;
        if (consumer != null) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    consumer.accept(AquaSheetSupport.getOption(jOptionPane));
                }
            };
        }
        AquaSheetSupport.displayAsSheet(jDialog, runnable);
    }

    private static int getOption(JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (object == null) {
            return -1;
        }
        Object[] objectArray = jOptionPane.getOptions();
        if (objectArray == null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isFileChooserSheet(@NotNull JRootPane jRootPane) {
        return Boolean.TRUE.equals(jRootPane.getClientProperty(FILE_CHOOSER_SHEET_KEY));
    }

    public static void showFileChooserAsSheet(Window window, JFileChooser jFileChooser, Consumer<Integer> consumer) throws UnsupportedOperationException {
        Object object;
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        String string = fileChooserUI.getDialogTitle(jFileChooser);
        jFileChooser.putClientProperty("AccessibleDescription", string);
        JDialog jDialog = new JDialog(window, "");
        jDialog.setComponentOrientation(jFileChooser.getComponentOrientation());
        JRootPane jRootPane = jDialog.getRootPane();
        jRootPane.setWindowDecorationStyle(6);
        jRootPane.putClientProperty(FILE_CHOOSER_SHEET_KEY, true);
        jRootPane.putClientProperty(IS_SHEET_KEY, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        if (OSXSystemProperties.OSVersion >= 1013) {
            object = jDialog.getPreferredSize();
            jDialog.setSize((Dimension)object);
        } else {
            jDialog.pack();
        }
        object = new FileChooserActionListener(jDialog);
        jFileChooser.addActionListener((ActionListener)object);
        jFileChooser.rescanCurrentDirectory();
        Runnable runnable = new Runnable(){
            final /* synthetic */ FileChooserActionListener val$listener;
            final /* synthetic */ JFileChooser val$fc;
            final /* synthetic */ JDialog val$dialog;
            final /* synthetic */ Consumer val$resultConsumer;
            {
                this.val$listener = fileChooserActionListener;
                this.val$fc = jFileChooser;
                this.val$dialog = jDialog;
                this.val$resultConsumer = consumer;
            }

            @Override
            public void run() {
                int n = this.val$listener.returnValue;
                this.val$fc.removeActionListener(this.val$listener);
                this.val$dialog.getContentPane().removeAll();
                this.val$dialog.dispose();
                if (this.val$resultConsumer != null) {
                    this.val$resultConsumer.accept(n);
                }
            }
        };
        try {
            AquaSheetSupport.displayAsSheet(jDialog, runnable);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            jDialog.getContentPane().removeAll();
            jDialog.dispose();
            throw unsupportedOperationException;
        }
    }

    public static void displayAsSheet(Window window, Runnable runnable) throws UnsupportedOperationException {
        int n;
        Object object;
        Object object2;
        Window window2 = window.getOwner();
        if (window2 == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: no owner window");
        }
        if (!window2.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: owner window is not visible");
        }
        if (window.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: the window must not be visible");
        }
        if (window instanceof Dialog) {
            object2 = (Dialog)window;
            ((Dialog)object2).setModalityType(Dialog.ModalityType.MODELESS);
        }
        object2 = null;
        Dimension dimension = window.getSize();
        Object object3 = null;
        int n2 = window.getInsets().top;
        String string = "noTitleBar";
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane != null) {
            jRootPane.putClientProperty(IS_SHEET_KEY, true);
            object2 = jRootPane.getClientProperty("Aqua.backgroundStyle");
            AquaSheetSupport.debug("Setting background style client property to vibrantSheet");
            jRootPane.putClientProperty("Aqua.backgroundStyle", "vibrantSheet");
            object = AquaRootPaneUI.getWindowStyleKey(jRootPane);
            if (OSXSystemProperties.OSVersion >= 1013) {
                if (!"undecorated".equals(object)) {
                    if (!string.equals(object)) {
                        object3 = object;
                        AquaSheetSupport.debug("Installing the window style for a sheet: " + string);
                        jRootPane.putClientProperty("Aqua.windowStyle", string);
                    }
                    AquaUtils.ensureWindowPeer(window);
                    window.validate();
                    jRootPane.setLocation(0, 0);
                    window.setSize(window.getWidth(), window.getHeight() - n2);
                }
            } else if ("noTitleBar".equals(object)) {
                object3 = object;
                AquaSheetSupport.debug("Removing the window style for a sheet: " + (String)object);
                jRootPane.putClientProperty("Aqua.windowStyle", null);
                window.pack();
            }
        }
        AquaUtils.ensureWindowPeer(window);
        if (jRootPane != null) {
            object = window.getInsets();
            if (((Insets)object).top == 0) {
                AquaSheetSupport.prepaintSheet(window, jRootPane);
            }
        }
        object = new SheetCloser(window, window2, runnable, object2, (String)object3, n2, dimension);
        if ("true".equals(System.getProperty("VAqua.injectSheetDisplayFailure"))) {
            Utils.logDebug("Injected failure to display sheet");
            n = -1;
        } else {
            n = (int)AquaUtils.execute(window, l -> AquaSheetSupport.displayAsSheet(l, window2));
        }
        if (n != 0) {
            ((SheetCloser)object).dispose();
            throw new UnsupportedOperationException("Unable to display as sheet");
        }
        window.setVisible(true);
    }

    private static void prepaintSheet(@NotNull Window window, @NotNull JRootPane jRootPane) {
        window.validate();
        AquaSheetSupport.debug("Painting the sheet");
        AquaUtils.paintImmediately(window, jRootPane);
        AquaUtils.syncAWTView(window);
    }

    private static long displayAsSheet(long l, Window window) {
        return AquaUtils.execute(window, l2 -> AquaSheetSupport.nativeDisplayAsSheet(l, l2));
    }

    public static boolean isSheet(Window window) {
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        return jRootPane != null && AquaSheetSupport.isSheet(jRootPane);
    }

    public static boolean isSheet(@NotNull JComponent jComponent) {
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane != null) {
            Object object = jRootPane.getClientProperty("Aqua.backgroundStyle");
            return AquaSheetSupport.isSheetFromBackgroundStyle(object);
        }
        return false;
    }

    public static void registerIsSheetChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
        jRootPane.addPropertyChangeListener("Aqua.backgroundStyle", new SheetPropertyChangeListener(jRootPane, changeListener));
    }

    public static void unregisterIsSheetChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = jRootPane.getPropertyChangeListeners("Aqua.backgroundStyle")) {
            SheetPropertyChangeListener sheetPropertyChangeListener;
            if (!(propertyChangeListener instanceof SheetPropertyChangeListener) || (sheetPropertyChangeListener = (SheetPropertyChangeListener)propertyChangeListener).rp != jRootPane || sheetPropertyChangeListener.l != changeListener) continue;
            jRootPane.removePropertyChangeListener("Aqua.backgroundStyle", sheetPropertyChangeListener);
        }
    }

    private static boolean isSheetFromBackgroundStyle(Object object) {
        return "vibrantSheet".equals(object);
    }

    private static void debug(@NotNull String string) {
        if (isDebug) {
            AquaUtils.syslog("AquaSheetSupport: " + string);
        }
    }

    private static native int nativeDisplayAsSheet(long var0, long var2);

    private static native int nativeEndSheetSession(long var0, long var2);

    private static class FileChooserActionListener
    implements ActionListener {
        private Window d;
        int returnValue = -1;

        public FileChooserActionListener(@NotNull Window window) {
            this.d = window;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ApproveSelection")) {
                this.returnValue = 0;
                this.d.setVisible(false);
            } else if (string.equals("CancelSelection")) {
                this.returnValue = 1;
                this.d.setVisible(false);
            }
        }
    }

    private static class SheetCloser
    extends WindowAdapter
    implements HierarchyListener {
        @NotNull
        private final Window w;
        @NotNull
        private final Window owner;
        @Nullable
        private final Runnable closeHandler;
        @Nullable
        private final Object oldBackgroundStyle;
        @Nullable
        private final String windowStyle;
        private final int oldTop;
        @NotNull
        private final Dimension originalSize;
        private boolean hasClosed = false;

        public SheetCloser(@NotNull Window window, @NotNull Window window2, @Nullable Runnable runnable, @Nullable Object object, @Nullable String string, int n, @NotNull Dimension dimension) {
            this.w = window;
            this.owner = window2;
            this.closeHandler = runnable;
            this.oldBackgroundStyle = object;
            this.windowStyle = string;
            this.oldTop = n;
            this.originalSize = dimension;
            window.addWindowListener(this);
            window.addHierarchyListener(this);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !this.w.isVisible()) {
                this.completed();
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.completed();
        }

        private void completed() {
            if (!this.hasClosed) {
                this.hasClosed = true;
                this.dispose();
                this.endSession();
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
        }

        private long endSession() {
            return AquaUtils.execute(this.w, l -> this.endSession(l, this.owner));
        }

        private long endSession(long l, @NotNull Window window) {
            return AquaUtils.execute(window, l2 -> AquaSheetSupport.nativeEndSheetSession(l, l2));
        }

        public void dispose() {
            this.w.removeWindowListener(this);
            this.w.removeHierarchyListener(this);
            JRootPane jRootPane = AquaUtils.getRootPane(this.w);
            if (jRootPane != null) {
                jRootPane.putClientProperty("Aqua.backgroundStyle", this.oldBackgroundStyle);
                if (this.oldTop > 0) {
                    AquaUtils.restoreTitledWindowStyle(this.w, this.oldTop, this.originalSize);
                    AquaUtils.syncAWTView(this.w);
                }
                if (this.windowStyle != null && !this.windowStyle.equals("noTitleBar")) {
                    jRootPane.putClientProperty("Aqua.windowStyle", this.windowStyle);
                    this.w.setSize(this.w.getWidth(), this.w.getHeight() + this.oldTop);
                    jRootPane.setLocation(0, this.oldTop);
                }
            }
        }
    }

    private static class SheetPropertyChangeListener
    implements PropertyChangeListener {
        private JRootPane rp;
        private ChangeListener l;

        public SheetPropertyChangeListener(JRootPane jRootPane, ChangeListener changeListener) {
            this.rp = jRootPane;
            this.l = changeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = AquaSheetSupport.isSheetFromBackgroundStyle(propertyChangeEvent.getOldValue());
            boolean bl2 = AquaSheetSupport.isSheetFromBackgroundStyle(propertyChangeEvent.getNewValue());
            if (bl2 != bl) {
                this.l.stateChanged(new ChangeEvent(this.rp));
            }
        }
    }
}

