/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSplitPaneDivider;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;

public class AquaSplitPaneUI
extends BasicSplitPaneUI
implements MouseListener,
ContainerListener,
PropertyChangeListener,
AquaComponentUI {
    public static final String DIVIDER_PAINTER_KEY = "JSplitPane.dividerPainter";
    public static final String SPLIT_PANE_STYLE_KEY = "JSplitPane.style";
    public static final String QUAQUA_SPLIT_PANE_STYLE_KEY = "Quaqua.SplitPane.style";
    private final AquaUIPainter painter = AquaPainting.create();
    protected static SplitPaneStyle defaultStyle = SplitPaneStyle.THIN;
    protected SplitPaneStyle style = defaultStyle;
    private boolean isReorderingComponents;
    private boolean initialDividerUpdatePerformed;
    private boolean ignoreDividerLocationChange;
    private boolean isInLayout;
    @NotNull
    protected BasicContextualColors colors = AquaColors.CLEAR_CONTROL_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new AquaSplitPaneDivider(this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.splitPane, "opaque", false);
        this.splitPane.setOneTouchExpandable(false);
        SplitPaneStyle splitPaneStyle = this.getClientSpecifiedStyle();
        if (splitPaneStyle != null) {
            this.style = splitPaneStyle;
        }
        this.updateDividerSize();
        this.configureAppearanceContext(null, this.splitPane);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.addPropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.addPropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.addContainerListener(this);
        AppearanceManager.installListeners(this.splitPane);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListeners(this.splitPane);
        this.splitPane.removeContainerListener(this);
        this.splitPane.removePropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.removePropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.removePropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance, (JSplitPane)jComponent);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance, @NotNull JSplitPane jSplitPane) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(jSplitPane);
        }
        AquaUIPainter.State state = AquaUIPainter.State.ACTIVE;
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(jSplitPane, this.appearanceContext, this.colors);
        jSplitPane.repaint();
    }

    protected void updateStyle() {
        SplitPaneStyle splitPaneStyle = this.getClientSpecifiedStyle();
        if (splitPaneStyle == null) {
            splitPaneStyle = defaultStyle;
        }
        if (this.style != splitPaneStyle) {
            this.style = splitPaneStyle;
            this.updateDividerSize();
            this.divider.repaint();
        }
    }

    protected void updateDividerSize() {
        int n = this.getFixedDividerSize();
        if (n > 0) {
            LookAndFeel.installProperty(this.splitPane, "dividerSize", n);
            this.divider.setDividerSize(this.splitPane.getDividerSize());
            this.dividerSize = this.divider.getDividerSize();
        }
    }

    public AquaUIPainter.DividerWidget getWidget() {
        switch (this.style.ordinal()) {
            case 2: {
                return AquaUIPainter.DividerWidget.PANE_SPLITTER;
            }
            case 1: {
                return AquaUIPainter.DividerWidget.THICK_DIVIDER;
            }
        }
        return AquaUIPainter.DividerWidget.THIN_DIVIDER;
    }

    public int getFixedDividerSize() {
        boolean bl = this.splitPane.getOrientation() == 1;
        AquaUIPainter.DividerWidget dividerWidget = this.getWidget();
        AquaUIPainter.Orientation orientation = bl ? AquaUIPainter.Orientation.VERTICAL : AquaUIPainter.Orientation.HORIZONTAL;
        SplitPaneDividerLayoutConfiguration splitPaneDividerLayoutConfiguration = new SplitPaneDividerLayoutConfiguration(dividerWidget, orientation, 0);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo((LayoutConfiguration)splitPaneDividerLayoutConfiguration);
        return (int)(bl ? layoutInfo.getFixedVisualWidth() : layoutInfo.getFixedVisualHeight());
    }

    public int getDividerExtension() {
        AquaUIPainter.DividerWidget dividerWidget = this.getWidget();
        if (dividerWidget == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            return 2;
        }
        return 0;
    }

    protected SplitPaneStyle getClientSpecifiedStyle() {
        Object object = this.splitPane.getClientProperty(SPLIT_PANE_STYLE_KEY);
        if (object != null) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals("thin")) {
                    return SplitPaneStyle.THIN;
                }
                if (string.equals("thick")) {
                    return SplitPaneStyle.THICK;
                }
                if (string.equals("paneSplitter")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
            }
        } else {
            object = this.splitPane.getClientProperty(QUAQUA_SPLIT_PANE_STYLE_KEY);
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals("bar")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
                if (string.equals("thumb")) {
                    return SplitPaneStyle.THICK;
                }
            }
        }
        return null;
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, SPLIT_PANE_STYLE_KEY, QUAQUA_SPLIT_PANE_STYLE_KEY);
    }

    @Override
    public boolean isContinuousLayout() {
        return true;
    }

    @Override
    public Component getNonContinuousLayoutDivider() {
        return null;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.ensureComponentOrder();
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureComponentOrder() {
        if (!this.isReorderingComponents) {
            this.isReorderingComponents = true;
            try {
                Component component = this.splitPane.getLeftComponent();
                Component component2 = this.splitPane.getRightComponent();
                int n = this.splitPane.getDividerLocation();
                if (component != null) {
                    this.splitPane.setLeftComponent(null);
                }
                if (component2 != null) {
                    this.splitPane.setRightComponent(null);
                }
                this.splitPane.remove(this.divider);
                this.splitPane.add((Component)this.divider, "divider");
                this.splitPane.setLeftComponent(component);
                this.splitPane.setRightComponent(component2);
                this.splitPane.setDividerLocation(n);
            }
            finally {
                this.isReorderingComponents = false;
            }
        }
    }

    @Override
    protected void resetLayoutManager() {
        super.resetLayoutManager();
        LayoutManager2 layoutManager2 = (LayoutManager2)this.splitPane.getLayout();
        MyLayoutManager myLayoutManager = new MyLayoutManager(layoutManager2);
        this.splitPane.setLayout(myLayoutManager);
    }

    @Override
    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        if (!this.ignoreDividerLocationChange) {
            super.setDividerLocation(jSplitPane, n);
        }
    }

    protected void updateDividerBounds() {
        if (this.divider != null) {
            this.initialDividerUpdatePerformed = true;
            int n = this.getDividerExtension();
            if (n > 0) {
                int n2 = this.divider.getX();
                int n3 = this.divider.getY();
                int n4 = this.divider.getWidth();
                int n5 = this.divider.getHeight();
                if (this.splitPane.getOrientation() == 1) {
                    this.divider.setBounds(n2 - n, n3, n4 + 2 * n, n5);
                } else {
                    this.divider.setBounds(n2, n3 - n, n4, n5 + 2 * n);
                }
            }
        }
    }

    @Override
    public int getDividerLocation(JSplitPane jSplitPane) {
        int n;
        int n2 = n = this.isInLayout ? 0 : this.getDividerExtension();
        if (this.splitPane.getOrientation() == 1) {
            return this.divider.getLocation().x + n;
        }
        return this.divider.getLocation().y + n;
    }

    @Override
    public void dragDividerTo(int n) {
        super.dragDividerTo(n);
    }

    @Override
    public void finishDraggingTo(int n) {
        super.finishDraggingTo(n);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque()) {
            AquaUtils.fillRect(graphics, jComponent, 2);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.initialDividerUpdatePerformed) {
            this.updateDividerBounds();
            this.ignoreDividerLocationChange = true;
            this.splitPane.setDividerLocation(this.getDividerLocation(this.splitPane));
            this.ignoreDividerLocationChange = false;
        }
        super.paint(graphics, jComponent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        if (!this.splitPane.isOneTouchExpandable()) {
            return;
        }
        double d = this.splitPane.getResizeWeight();
        int n = this.splitPane.getMinimumDividerLocation();
        int n2 = this.splitPane.getMaximumDividerLocation();
        int n3 = this.splitPane.getDividerLocation();
        int n4 = this.splitPane.getLastDividerLocation();
        if (n3 >= n2 - 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (n3 < n + 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (d > 0.5) {
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.setDividerLocation(n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            if (string.equals(DIVIDER_PAINTER_KEY)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Border) {
                    this.divider.setBorder((Border)object);
                } else {
                    this.divider.setBorder(null);
                }
            } else if (this.isStyleProperty(string)) {
                this.updateStyle();
            }
        }
    }

    public static enum SplitPaneStyle {
        THIN,
        THICK,
        PANE_SPLITTER;

    }

    protected class MyLayoutManager
    implements LayoutManager2 {
        LayoutManager2 delegate;

        public MyLayoutManager(LayoutManager2 layoutManager2) {
            this.delegate = layoutManager2;
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.delegate.addLayoutComponent(component, object);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.delegate.maximumLayoutSize(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return this.delegate.getLayoutAlignmentX(container);
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return this.delegate.getLayoutAlignmentY(container);
        }

        @Override
        public void invalidateLayout(Container container) {
            this.delegate.invalidateLayout(container);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.delegate.addLayoutComponent(string, component);
        }

        @Override
        public void layoutContainer(Container container) {
            AquaSplitPaneUI.this.isInLayout = true;
            this.delegate.layoutContainer(container);
            AquaSplitPaneUI.this.isInLayout = false;
            Dimension dimension = container.getSize();
            if (dimension.height <= 0 || dimension.width <= 0) {
                return;
            }
            AquaSplitPaneUI.this.updateDividerBounds();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.delegate.minimumLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.delegate.preferredLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.delegate.removeLayoutComponent(component);
        }
    }
}

