/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.Utils;

public class DynamicIcon
implements Icon,
ChangeListener {
    private final int width;
    private final int height;
    @Nullable
    private DynamicIcon replacement;
    @Nullable
    private Image image;
    @NotNull
    private final EventListenerList listenerList = new EventListenerList();

    public DynamicIcon(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installIcon(@NotNull Icon icon) {
        boolean bl = false;
        DynamicIcon dynamicIcon = this;
        synchronized (dynamicIcon) {
            if (icon instanceof DynamicIcon) {
                if (this.replacement != null) {
                    this.replacement.removeChangeListener(this);
                }
                this.replacement = (DynamicIcon)icon;
                this.image = this.replacement.getCurrentImage();
                this.replacement.addChangeListener(this);
                bl = true;
            } else {
                Image image = AquaIcon.getImageForIcon(icon);
                if (image != null) {
                    this.image = image;
                    bl = true;
                } else {
                    Utils.logError("No image for icon: " + icon);
                }
            }
        }
        if (bl) {
            this.iconChanged();
        }
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent changeEvent) {
        if (this.replacement != null) {
            this.image = this.replacement.getCurrentImage();
            this.iconChanged();
        }
    }

    private synchronized void iconChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireChangeEvent();
        } else {
            SwingUtilities.invokeLater(this::fireChangeEvent);
        }
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    @Nullable
    public synchronized Image getCurrentImage() {
        return this.image;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Image image = this.getCurrentImage();
        if (image != null) {
            graphics.drawImage(image, n, n2, this.width, this.height, component);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

