/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;

public abstract class ListSelectionBoundsTracker
implements SelectionBoundsTracker {
    @Nullable
    protected JList<?> list;
    @Nullable
    protected Consumer<SelectionBoundsDescription> consumer;
    @Nullable
    private SelectionBoundsDescription currentSelectionDescription;
    private int currentWidth;

    public ListSelectionBoundsTracker(@NotNull JList<?> jList, @Nullable Consumer<SelectionBoundsDescription> consumer) {
        this.list = jList;
        this.consumer = consumer;
        this.update();
        if (consumer != null && this.currentSelectionDescription == null) {
            consumer.accept(null);
        }
    }

    @Override
    public void dispose() {
        this.list = null;
        this.consumer = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            this.currentWidth = 0;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(@Nullable Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Override
    public void update() {
        if (this.list != null) {
            SelectionBoundsDescription selectionBoundsDescription = this.getSelectionBoundsDescription(this.list);
            try {
                this.updateFromSelectedRows(selectionBoundsDescription);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @NotNull
    private SelectionBoundsDescription getSelectionBoundsDescription(@NotNull JList<?> jList) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = -1;
        JList.DropLocation dropLocation = jList.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && (n4 = dropLocation.getIndex()) >= 0) {
            n3 = 1;
        }
        int[] nArray = null;
        int n5 = jList.getMinSelectionIndex();
        int n6 = jList.getMaxSelectionIndex();
        if (n5 >= 0 && n6 >= n5) {
            nArray = new int[n6 - n5 + 1];
            int n7 = 0;
            for (n2 = n5; n2 <= n6; ++n2) {
                if (!jList.isSelectedIndex(n2) || n2 == n4) continue;
                nArray[n7++] = n2;
                ++n3;
            }
        }
        SelectionBoundsDescription selectionBoundsDescription = new SelectionBoundsDescription(n3);
        if (n4 >= 0) {
            Rectangle rectangle = jList.getCellBounds(n4, n4);
            n = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
            selectionBoundsDescription.addDropTargetRegion(n, rectangle.height);
            --n3;
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                Rectangle rectangle = jList.getCellBounds(n, n);
                int n8 = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
                selectionBoundsDescription.addRegion(n8, rectangle.height);
            }
        }
        return selectionBoundsDescription;
    }

    protected void updateFromSelectedRows(@NotNull SelectionBoundsDescription selectionBoundsDescription) {
        int n;
        int n2 = n = this.list != null ? this.list.getWidth() : 0;
        if (n != this.currentWidth || !Objects.equals(selectionBoundsDescription, this.currentSelectionDescription)) {
            this.currentSelectionDescription = selectionBoundsDescription;
            this.currentWidth = n;
            if (this.consumer != null) {
                this.consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    protected int convertRowYCoordinateToSelectionDescription(int n) {
        return n;
    }
}

