/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;
import org.violetlib.aqua.SelectionRegion;

public abstract class MenuSelectionBoundsTracker
implements SelectionBoundsTracker {
    public static boolean isDebug = false;
    @Nullable
    protected JPopupMenu menu;
    @Nullable
    protected Consumer<SelectionBoundsDescription> consumer;
    @Nullable
    private SelectionBoundsDescription currentSelectionDescription;
    @Nullable
    private JMenuItem selectedItem;
    @Nullable
    private SelectionRegion selectedItemRegion;

    public MenuSelectionBoundsTracker(@NotNull JPopupMenu jPopupMenu, @Nullable Consumer<SelectionBoundsDescription> consumer) {
        this.menu = jPopupMenu;
        this.consumer = consumer;
    }

    @Override
    public void update() {
    }

    public void paintingItem(@NotNull JMenuItem jMenuItem, @NotNull AppearanceContext appearanceContext) {
        if (appearanceContext.isSelected()) {
            if (jMenuItem != this.selectedItem) {
                this.selectedItem = jMenuItem;
                this.selectedItemRegion = this.getSelectionRegion(jMenuItem);
                if (isDebug) {
                    AquaUtils.syslog("new selected item: " + jMenuItem.getText());
                }
                this.selectionRegionChanged();
            } else {
                assert (this.selectedItemRegion != null);
                SelectionRegion selectionRegion = this.getSelectionRegion(jMenuItem);
                if (!selectionRegion.matches(this.selectedItemRegion)) {
                    this.selectedItemRegion = selectionRegion;
                    if (isDebug) {
                        AquaUtils.syslog("new selected item bounds: " + jMenuItem.getText());
                    }
                    this.selectionRegionChanged();
                }
            }
        } else if (jMenuItem == this.selectedItem) {
            if (isDebug) {
                AquaUtils.syslog("deselected item: " + jMenuItem.getText());
            }
            this.selectedItem = null;
            this.selectedItemRegion = null;
            this.selectionRegionChanged();
        }
    }

    @Override
    public void dispose() {
        this.menu = null;
        this.consumer = null;
        this.selectedItem = null;
        this.selectedItemRegion = null;
        this.currentSelectionDescription = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(@Nullable Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    private void selectionRegionChanged() {
        SelectionBoundsDescription selectionBoundsDescription = this.currentSelectionDescription = this.selectedItemRegion != null ? SelectionBoundsDescription.create(this.selectedItemRegion) : null;
        if (this.consumer != null) {
            this.consumer.accept(this.currentSelectionDescription);
        }
    }

    @NotNull
    private SelectionRegion getSelectionRegion(@NotNull Component component) {
        Rectangle rectangle = component.getBounds();
        int n = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
        return new SelectionRegion(n, rectangle.height);
    }

    protected int convertRowYCoordinateToSelectionDescription(int n) {
        return n;
    }
}

