/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaIcon;

public abstract class ProcessedImageCache {
    private final WeakHashMap<Object, ImageInfo> imageMap = new WeakHashMap();

    @Nullable
    public Image getProcessedImage(@NotNull Icon icon, @Nullable Object object) {
        ImageInfo imageInfo = this.getIconImageInfo(icon);
        return imageInfo != null ? imageInfo.getProcessedImage(object) : null;
    }

    @NotNull
    public Image getProcessedImage(@NotNull Image image, @NotNull Object object) {
        ImageInfo imageInfo = this.getImageInfo(image);
        return imageInfo.getProcessedImage(object);
    }

    public boolean isTemplateImage(@NotNull Image image) {
        ImageInfo imageInfo = this.getImageInfo(image);
        return imageInfo.isTemplate;
    }

    public boolean isTemplateIcon(@NotNull Icon icon) {
        ImageInfo imageInfo = this.getIconImageInfo(icon);
        return imageInfo != null && imageInfo.isTemplate;
    }

    @Nullable
    private ImageInfo getIconImageInfo(@NotNull Icon icon) {
        Image image;
        ImageInfo imageInfo = this.imageMap.get(icon);
        if (imageInfo == null && (image = AquaIcon.getImageForIcon(icon)) != null) {
            imageInfo = this.getImageInfo(image);
            this.imageMap.put(icon, imageInfo);
        }
        return imageInfo;
    }

    @NotNull
    private ImageInfo getImageInfo(@NotNull Image image) {
        ImageInfo imageInfo = this.imageMap.get(image);
        if (imageInfo == null) {
            boolean bl = this.determineTemplateImage(image);
            imageInfo = new ImageInfo(image, bl);
            this.imageMap.put(image, imageInfo);
        }
        return imageInfo;
    }

    protected abstract boolean determineTemplateImage(@NotNull Image var1);

    @NotNull
    protected abstract Image createImageFromTemplate(@NotNull Image var1, @NotNull Color var2);

    @NotNull
    protected abstract Image createProcessedImage(@NotNull Image var1, @NotNull Object var2);

    private class ImageInfo {
        @NotNull
        Image source;
        boolean isTemplate;
        @Nullable
        Map<Object, SoftReference<Image>> processedImageMap;

        private ImageInfo(Image image, boolean bl) {
            this.source = image;
            this.isTemplate = bl;
        }

        @NotNull
        public Image getProcessedImage(@Nullable Object object) {
            if (this.processedImageMap == null) {
                this.processedImageMap = new HashMap<Object, SoftReference<Image>>();
            }
            Image image = null;
            SoftReference<Image> softReference = this.processedImageMap.get(object);
            if (softReference != null) {
                image = softReference.get();
            }
            if (image != null) {
                return image;
            }
            if (object == null) {
                image = this.source;
            } else if (object instanceof Color) {
                Color color = (Color)object;
                image = this.isTemplate ? ProcessedImageCache.this.createImageFromTemplate(this.source, color) : this.source;
            } else {
                image = ProcessedImageCache.this.createProcessedImage(this.source, object);
            }
            this.processedImageMap.put(object, new SoftReference<Image>(image));
            return image;
        }
    }
}

