/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;

public abstract class TreeSelectionBoundsTracker
implements SelectionBoundsTracker {
    @Nullable
    protected JTree tree;
    @Nullable
    protected Consumer<SelectionBoundsDescription> consumer;
    @Nullable
    private SelectionBoundsDescription currentSelectionDescription;
    private int currentWidth;

    public TreeSelectionBoundsTracker(@NotNull JTree jTree, @Nullable Consumer<SelectionBoundsDescription> consumer) {
        this.tree = jTree;
        this.consumer = consumer;
        this.update();
        if (consumer != null && this.currentSelectionDescription == null) {
            consumer.accept(null);
        }
    }

    @Override
    public void dispose() {
        this.tree = null;
        this.consumer = null;
    }

    @Override
    public void reset() {
        if (this.currentSelectionDescription != null) {
            this.currentSelectionDescription = null;
            this.currentWidth = 0;
            if (this.consumer != null) {
                this.consumer.accept(null);
            }
        }
    }

    @Override
    public void setConsumer(@Nullable Consumer<SelectionBoundsDescription> consumer) {
        if (consumer != this.consumer) {
            this.consumer = consumer;
            if (consumer != null) {
                consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    @Override
    public void update() {
        if (this.tree != null) {
            SelectionBoundsDescription selectionBoundsDescription = this.getSelectionBoundsDescription(this.tree);
            try {
                this.updateFromSelectedRows(selectionBoundsDescription);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @NotNull
    private SelectionBoundsDescription getSelectionBoundsDescription(@NotNull JTree jTree) {
        Object object;
        int n;
        Object object2;
        int n2 = 0;
        int n3 = -1;
        JTree.DropLocation dropLocation = jTree.getDropLocation();
        if (dropLocation != null && dropLocation.getChildIndex() < 0 && (object2 = dropLocation.getPath()) != null && (n3 = jTree.getRowForPath((TreePath)object2)) >= 0) {
            n2 = 1;
        }
        object2 = null;
        int n4 = jTree.getMinSelectionRow();
        int n5 = jTree.getMaxSelectionRow();
        if (n4 >= 0 && n5 >= n4) {
            object2 = new int[n5 - n4 + 1];
            int n6 = 0;
            for (n = n4; n <= n5; ++n) {
                if (!jTree.isRowSelected(n) || n == n3) continue;
                object2[n6++] = n;
                ++n2;
            }
        }
        SelectionBoundsDescription selectionBoundsDescription = new SelectionBoundsDescription(n2);
        if (n3 >= 0) {
            Rectangle rectangle = jTree.getRowBounds(n3);
            object = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
            selectionBoundsDescription.addDropTargetRegion((int)object, rectangle.height);
            --n2;
        }
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                object = object2[n];
                Rectangle rectangle = jTree.getRowBounds((int)object);
                int n7 = this.convertRowYCoordinateToSelectionDescription(rectangle.y);
                selectionBoundsDescription.addRegion(n7, rectangle.height);
            }
        }
        return selectionBoundsDescription;
    }

    protected void updateFromSelectedRows(@NotNull SelectionBoundsDescription selectionBoundsDescription) {
        int n;
        int n2 = n = this.tree != null ? this.tree.getWidth() : 0;
        if (n != this.currentWidth || !Objects.equals(selectionBoundsDescription, this.currentSelectionDescription)) {
            this.currentSelectionDescription = selectionBoundsDescription;
            this.currentWidth = n;
            if (this.consumer != null) {
                this.consumer.accept(this.currentSelectionDescription);
            }
        }
    }

    protected int convertRowYCoordinateToSelectionDescription(int n) {
        return n;
    }
}

