/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class OSXCollator
extends Collator {
    private Collator collator;

    public OSXCollator() {
        this(Locale.getDefault());
    }

    public OSXCollator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        if (this.collator instanceof RuleBasedCollator) {
            String string = ((RuleBasedCollator)this.collator).getRules();
            int n = string.indexOf(",'-'");
            int n2 = string.indexOf(60);
            if (n2 == string.indexOf("'<'")) {
                n2 = string.indexOf(60, n2 + 2);
            }
            if (n != -1 && n < n2) {
                string = string.substring(0, n) + string.substring(n + 4, n2) + "<'-'" + string.substring(n2);
            }
            n = string.indexOf(";' '");
            n2 = string.indexOf(60);
            if (n2 == string.indexOf("'<'")) {
                n2 = string.indexOf(60, n2 + 2);
            }
            if (n != -1 && n < n2) {
                string = string.substring(0, n) + string.substring(n + 4, n2) + "<' '" + string.substring(n2);
            }
            try {
                this.collator = new RuleBasedCollator(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
    }

    @Override
    public int compare(String string, String string2) {
        return this.collator.compare(this.expandNumbers(string), this.expandNumbers(string2));
    }

    @Override
    public CollationKey getCollationKey(String string) {
        return this.collator.getCollationKey(this.expandNumbers(string));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OSXCollator) {
            OSXCollator oSXCollator = (OSXCollator)object;
            return this.collator.equals(oSXCollator.collator);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.collator.hashCode();
    }

    private String expandNumbers(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                stringBuffer2.append(c);
                continue;
            }
            if (stringBuffer2.length() != 0) {
                if (stringBuffer2.length() < 10) {
                    stringBuffer.append("00");
                    stringBuffer.append(stringBuffer2.length());
                } else if (stringBuffer2.length() < 100) {
                    stringBuffer.append("0");
                    stringBuffer.append(stringBuffer2.length());
                } else if (stringBuffer2.length() < 1000) {
                    stringBuffer.append(stringBuffer2.length());
                } else if (stringBuffer2.length() > 999) {
                    stringBuffer.append("999");
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            stringBuffer.append(c);
        }
        if (stringBuffer2.length() != 0) {
            if (stringBuffer2.length() < 10) {
                stringBuffer.append("00");
                stringBuffer.append(stringBuffer2.length());
            } else if (stringBuffer2.length() < 100) {
                stringBuffer.append("0");
                stringBuffer.append(stringBuffer2.length());
            } else if (stringBuffer2.length() < 1000) {
                stringBuffer.append(stringBuffer2.length());
            } else if (stringBuffer2.length() > 999) {
                stringBuffer.append("999");
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }
}

