/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_4_1;

import java.util.List;
import org.virtualbox_4_1.Helper;
import org.virtualbox_4_1.IUSBDeviceFilter;
import org.virtualbox_4_1.IUnknown;
import org.virtualbox_4_1.VBoxException;
import org.virtualbox_4_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_4_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_4_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IUSBController
extends IUnknown {
    public IUSBController(String string, VboxPortType vboxPortType) {
        super(string, vboxPortType);
    }

    public Boolean getEnabled() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabled(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void setEnabled(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabled(this.obj, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Boolean getEnabledEhci() {
        try {
            Boolean bl = this.port.iusbControllerGetEnabledEhci(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void setEnabledEhci(Boolean bl) {
        try {
            this.port.iusbControllerSetEnabledEhci(this.obj, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Boolean getProxyAvailable() {
        try {
            Boolean bl = this.port.iusbControllerGetProxyAvailable(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public Integer getUSBStandard() {
        try {
            Integer n = this.port.iusbControllerGetUSBStandard(this.obj);
            return n;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public List<IUSBDeviceFilter> getDeviceFilters() {
        try {
            List<String> list = this.port.iusbControllerGetDeviceFilters(this.obj);
            return Helper.wrap(IUSBDeviceFilter.class, this.port, list);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public static IUSBController queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IUSBController(iUnknown.getWrapped(), iUnknown.getRemoteWSPort());
    }

    public IUSBDeviceFilter createDeviceFilter(String string) {
        try {
            String string2 = this.port.iusbControllerCreateDeviceFilter(this.obj, string);
            return string2.length() > 0 ? new IUSBDeviceFilter(string2, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public void insertDeviceFilter(Long l, IUSBDeviceFilter iUSBDeviceFilter) {
        try {
            this.port.iusbControllerInsertDeviceFilter(this.obj, l, iUSBDeviceFilter == null ? null : iUSBDeviceFilter.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }

    public IUSBDeviceFilter removeDeviceFilter(Long l) {
        try {
            String string = this.port.iusbControllerRemoveDeviceFilter(this.obj, l);
            return string.length() > 0 ? new IUSBDeviceFilter(string, this.port) : null;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg, invalidObjectFaultMsg.getMessage());
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg, runtimeFaultMsg.getMessage());
        }
    }
}

