@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
 */
public enum class SyncScope(
    public val javaValue: com.pulumi.azurenative.aad.enums.SyncScope,
) : ConvertibleToJava<com.pulumi.azurenative.aad.enums.SyncScope> {
    All(com.pulumi.azurenative.aad.enums.SyncScope.All),
    CloudOnly(com.pulumi.azurenative.aad.enums.SyncScope.CloudOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.aad.enums.SyncScope = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.enums.SyncScope): SyncScope =
            SyncScope.values().first { it.javaValue == javaType }
    }
}
