@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultIssueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specific issue for a particular config diagnostics validator
 * @property descriptionParams List of domain resource property name or values used to compose a rich description.
 * @property id Validation issue identifier.
 */
public data class ConfigDiagnosticsValidatorResultIssueArgs(
    public val descriptionParams: Output<List<String>>? = null,
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultIssueArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultIssueArgs =
        com.pulumi.azurenative.aad.inputs.ConfigDiagnosticsValidatorResultIssueArgs.builder()
            .descriptionParams(descriptionParams?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigDiagnosticsValidatorResultIssueArgs].
 */
@PulumiTagMarker
public class ConfigDiagnosticsValidatorResultIssueArgsBuilder internal constructor() {
    private var descriptionParams: Output<List<String>>? = null

    private var id: Output<String>? = null

    /**
     * @param value List of domain resource property name or values used to compose a rich description.
     */
    @JvmName("uiuptjohvnphjdhy")
    public suspend fun descriptionParams(`value`: Output<List<String>>) {
        this.descriptionParams = value
    }

    @JvmName("ehekoxsoypmtnpic")
    public suspend fun descriptionParams(vararg values: Output<String>) {
        this.descriptionParams = Output.all(values.asList())
    }

    /**
     * @param values List of domain resource property name or values used to compose a rich description.
     */
    @JvmName("edirtbsewkbxkwwd")
    public suspend fun descriptionParams(values: List<Output<String>>) {
        this.descriptionParams = Output.all(values)
    }

    /**
     * @param value Validation issue identifier.
     */
    @JvmName("mkevrkqmyrhbtsoc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of domain resource property name or values used to compose a rich description.
     */
    @JvmName("rmffbmykkgskjhpo")
    public suspend fun descriptionParams(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriptionParams = mapped
    }

    /**
     * @param values List of domain resource property name or values used to compose a rich description.
     */
    @JvmName("yuaoxkldmmpeuthn")
    public suspend fun descriptionParams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.descriptionParams = mapped
    }

    /**
     * @param value Validation issue identifier.
     */
    @JvmName("lumlnsuxkwopxnrj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ConfigDiagnosticsValidatorResultIssueArgs =
        ConfigDiagnosticsValidatorResultIssueArgs(
            descriptionParams = descriptionParams,
            id = id,
        )
}
