@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.ForestTrustArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Forest Trust Setting
 * @property friendlyName Friendly Name
 * @property remoteDnsIps Remote Dns ips
 * @property trustDirection Trust Direction
 * @property trustPassword Trust Password
 * @property trustedDomainFqdn Trusted Domain FQDN
 */
public data class ForestTrustArgs(
    public val friendlyName: Output<String>? = null,
    public val remoteDnsIps: Output<String>? = null,
    public val trustDirection: Output<String>? = null,
    public val trustPassword: Output<String>? = null,
    public val trustedDomainFqdn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.ForestTrustArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.ForestTrustArgs =
        com.pulumi.azurenative.aad.inputs.ForestTrustArgs.builder()
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .remoteDnsIps(remoteDnsIps?.applyValue({ args0 -> args0 }))
            .trustDirection(trustDirection?.applyValue({ args0 -> args0 }))
            .trustPassword(trustPassword?.applyValue({ args0 -> args0 }))
            .trustedDomainFqdn(trustedDomainFqdn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ForestTrustArgs].
 */
@PulumiTagMarker
public class ForestTrustArgsBuilder internal constructor() {
    private var friendlyName: Output<String>? = null

    private var remoteDnsIps: Output<String>? = null

    private var trustDirection: Output<String>? = null

    private var trustPassword: Output<String>? = null

    private var trustedDomainFqdn: Output<String>? = null

    /**
     * @param value Friendly Name
     */
    @JvmName("lydaqyrpcxihdbei")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Remote Dns ips
     */
    @JvmName("oosdgrvtgfvvasjv")
    public suspend fun remoteDnsIps(`value`: Output<String>) {
        this.remoteDnsIps = value
    }

    /**
     * @param value Trust Direction
     */
    @JvmName("glfmybgsqwgoarre")
    public suspend fun trustDirection(`value`: Output<String>) {
        this.trustDirection = value
    }

    /**
     * @param value Trust Password
     */
    @JvmName("abnohivravdofwxn")
    public suspend fun trustPassword(`value`: Output<String>) {
        this.trustPassword = value
    }

    /**
     * @param value Trusted Domain FQDN
     */
    @JvmName("fbhxsjkwrgqundux")
    public suspend fun trustedDomainFqdn(`value`: Output<String>) {
        this.trustedDomainFqdn = value
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("rbuuteghnekihjpa")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Remote Dns ips
     */
    @JvmName("qyyplraokbrsivuo")
    public suspend fun remoteDnsIps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDnsIps = mapped
    }

    /**
     * @param value Trust Direction
     */
    @JvmName("ldjmdqrtltymvfjd")
    public suspend fun trustDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustDirection = mapped
    }

    /**
     * @param value Trust Password
     */
    @JvmName("tepmeomrkhpcmlnu")
    public suspend fun trustPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustPassword = mapped
    }

    /**
     * @param value Trusted Domain FQDN
     */
    @JvmName("qmoguxbrvmynfgqa")
    public suspend fun trustedDomainFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedDomainFqdn = mapped
    }

    internal fun build(): ForestTrustArgs = ForestTrustArgs(
        friendlyName = friendlyName,
        remoteDnsIps = remoteDnsIps,
        trustDirection = trustDirection,
        trustPassword = trustPassword,
        trustedDomainFqdn = trustedDomainFqdn,
    )
}
