@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs.builder
import com.pulumi.azurenative.aad.kotlin.enums.ExternalAccess
import com.pulumi.azurenative.aad.kotlin.enums.Ldaps
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secure LDAP Settings
 * @property externalAccess A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
 * @property ldaps A flag to determine whether or not Secure LDAP is enabled or disabled.
 * @property pfxCertificate The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
 * @property pfxCertificatePassword The password to decrypt the provided Secure LDAP certificate pfx file.
 */
public data class LdapsSettingsArgs(
    public val externalAccess: Output<Either<String, ExternalAccess>>? = null,
    public val ldaps: Output<Either<String, Ldaps>>? = null,
    public val pfxCertificate: Output<String>? = null,
    public val pfxCertificatePassword: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs =
        com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs.builder()
            .externalAccess(
                externalAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ldaps(
                ldaps?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pfxCertificate(pfxCertificate?.applyValue({ args0 -> args0 }))
            .pfxCertificatePassword(pfxCertificatePassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LdapsSettingsArgs].
 */
@PulumiTagMarker
public class LdapsSettingsArgsBuilder internal constructor() {
    private var externalAccess: Output<Either<String, ExternalAccess>>? = null

    private var ldaps: Output<Either<String, Ldaps>>? = null

    private var pfxCertificate: Output<String>? = null

    private var pfxCertificatePassword: Output<String>? = null

    /**
     * @param value A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
     */
    @JvmName("rwfmoawenbkbnkao")
    public suspend fun externalAccess(`value`: Output<Either<String, ExternalAccess>>) {
        this.externalAccess = value
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP is enabled or disabled.
     */
    @JvmName("ldcxvuiatbovspvm")
    public suspend fun ldaps(`value`: Output<Either<String, Ldaps>>) {
        this.ldaps = value
    }

    /**
     * @param value The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
     */
    @JvmName("soafwnepdoprtilp")
    public suspend fun pfxCertificate(`value`: Output<String>) {
        this.pfxCertificate = value
    }

    /**
     * @param value The password to decrypt the provided Secure LDAP certificate pfx file.
     */
    @JvmName("kkowilwgsypxavfd")
    public suspend fun pfxCertificatePassword(`value`: Output<String>) {
        this.pfxCertificatePassword = value
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
     */
    @JvmName("twvcrucbtwykdhgx")
    public suspend fun externalAccess(`value`: Either<String, ExternalAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAccess = mapped
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
     */
    @JvmName("jjoknjngfptlvygl")
    public fun externalAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExternalAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalAccess = mapped
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
     */
    @JvmName("hermiwvraadbtgyp")
    public fun externalAccess(`value`: ExternalAccess) {
        val toBeMapped = Either.ofRight<String, ExternalAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalAccess = mapped
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP is enabled or disabled.
     */
    @JvmName("eajcuyfjlnuiitwu")
    public suspend fun ldaps(`value`: Either<String, Ldaps>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldaps = mapped
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP is enabled or disabled.
     */
    @JvmName("pdvhximyfqnmqhqk")
    public fun ldaps(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Ldaps>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldaps = mapped
    }

    /**
     * @param value A flag to determine whether or not Secure LDAP is enabled or disabled.
     */
    @JvmName("ltrjrocjcngdhbkq")
    public fun ldaps(`value`: Ldaps) {
        val toBeMapped = Either.ofRight<String, Ldaps>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldaps = mapped
    }

    /**
     * @param value The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
     */
    @JvmName("wcgwupigeadewhuc")
    public suspend fun pfxCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pfxCertificate = mapped
    }

    /**
     * @param value The password to decrypt the provided Secure LDAP certificate pfx file.
     */
    @JvmName("kcluokinirxyxcpy")
    public suspend fun pfxCertificatePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pfxCertificatePassword = mapped
    }

    internal fun build(): LdapsSettingsArgs = LdapsSettingsArgs(
        externalAccess = externalAccess,
        ldaps = ldaps,
        pfxCertificate = pfxCertificate,
        pfxCertificatePassword = pfxCertificatePassword,
    )
}
