@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PrivateLinkForAzureAd].
 */
@PulumiTagMarker
public class PrivateLinkForAzureAdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkForAzureAdArgs = PrivateLinkForAzureAdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkForAzureAdArgsBuilder.() -> Unit) {
        val builder = PrivateLinkForAzureAdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateLinkForAzureAd {
        val builtJavaResource =
            com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkForAzureAd(builtJavaResource)
    }
}

/**
 * PrivateLink Policy configuration object.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### privateLinkPolicyCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkForAzureAd = new AzureNative.AadIam.PrivateLinkForAzureAd("privateLinkForAzureAd", new()
 *     {
 *         AllTenants = false,
 *         Name = "myOrgPrivateLinkPolicy",
 *         OwnerTenantId = "950f8bca-bf4d-4a41-ad10-034e792a243d",
 *         PolicyName = "ddb1",
 *         ResourceGroup = "myOrgVnetRG",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "myOrgVnetPrivateLink",
 *         SubscriptionId = "57849194-ea1f-470b-abda-d195b25634c1",
 *         Tenants = new[]
 *         {
 *             "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *             "727b6ef1-18ab-4627-ac95-3f9cd945ed87",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateLinkForAzureAd(ctx, "privateLinkForAzureAd", &aadiam.PrivateLinkForAzureAdArgs{
 * 			AllTenants:        pulumi.Bool(false),
 * 			Name:              pulumi.String("myOrgPrivateLinkPolicy"),
 * 			OwnerTenantId:     pulumi.String("950f8bca-bf4d-4a41-ad10-034e792a243d"),
 * 			PolicyName:        pulumi.String("ddb1"),
 * 			ResourceGroup:     pulumi.String("myOrgVnetRG"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("myOrgVnetPrivateLink"),
 * 			SubscriptionId:    pulumi.String("57849194-ea1f-470b-abda-d195b25634c1"),
 * 			Tenants: pulumi.StringArray{
 * 				pulumi.String("3616657d-1c80-41ae-9d83-2a2776f2c9be"),
 * 				pulumi.String("727b6ef1-18ab-4627-ac95-3f9cd945ed87"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkForAzureAd = new PrivateLinkForAzureAd("privateLinkForAzureAd", PrivateLinkForAzureAdArgs.builder()
 *             .allTenants(false)
 *             .name("myOrgPrivateLinkPolicy")
 *             .ownerTenantId("950f8bca-bf4d-4a41-ad10-034e792a243d")
 *             .policyName("ddb1")
 *             .resourceGroup("myOrgVnetRG")
 *             .resourceGroupName("rg1")
 *             .resourceName("myOrgVnetPrivateLink")
 *             .subscriptionId("57849194-ea1f-470b-abda-d195b25634c1")
 *             .tenants(
 *                 "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *                 "727b6ef1-18ab-4627-ac95-3f9cd945ed87")
 *             .build());
 *     }
 * }
 * ```
 * ### privateLinkPolicyMinCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkForAzureAd = new AzureNative.AadIam.PrivateLinkForAzureAd("privateLinkForAzureAd", new()
 *     {
 *         AllTenants = false,
 *         Name = "myOrgPrivateLinkPolicy",
 *         OwnerTenantId = "950f8bca-bf4d-4a41-ad10-034e792a243d",
 *         PolicyName = "ddb1",
 *         ResourceGroup = "myOrgVnetRG",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "myOrgVnetPrivateLink",
 *         SubscriptionId = "57849194-ea1f-470b-abda-d195b25634c1",
 *         Tenants = new[]
 *         {
 *             "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *             "727b6ef1-18ab-4627-ac95-3f9cd945ed87",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewPrivateLinkForAzureAd(ctx, "privateLinkForAzureAd", &aadiam.PrivateLinkForAzureAdArgs{
 * 			AllTenants:        pulumi.Bool(false),
 * 			Name:              pulumi.String("myOrgPrivateLinkPolicy"),
 * 			OwnerTenantId:     pulumi.String("950f8bca-bf4d-4a41-ad10-034e792a243d"),
 * 			PolicyName:        pulumi.String("ddb1"),
 * 			ResourceGroup:     pulumi.String("myOrgVnetRG"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("myOrgVnetPrivateLink"),
 * 			SubscriptionId:    pulumi.String("57849194-ea1f-470b-abda-d195b25634c1"),
 * 			Tenants: pulumi.StringArray{
 * 				pulumi.String("3616657d-1c80-41ae-9d83-2a2776f2c9be"),
 * 				pulumi.String("727b6ef1-18ab-4627-ac95-3f9cd945ed87"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd;
 * import com.pulumi.azurenative.aadiam.PrivateLinkForAzureAdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkForAzureAd = new PrivateLinkForAzureAd("privateLinkForAzureAd", PrivateLinkForAzureAdArgs.builder()
 *             .allTenants(false)
 *             .name("myOrgPrivateLinkPolicy")
 *             .ownerTenantId("950f8bca-bf4d-4a41-ad10-034e792a243d")
 *             .policyName("ddb1")
 *             .resourceGroup("myOrgVnetRG")
 *             .resourceGroupName("rg1")
 *             .resourceName("myOrgVnetPrivateLink")
 *             .subscriptionId("57849194-ea1f-470b-abda-d195b25634c1")
 *             .tenants(
 *                 "3616657d-1c80-41ae-9d83-2a2776f2c9be",
 *                 "727b6ef1-18ab-4627-ac95-3f9cd945ed87")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:PrivateLinkForAzureAd myOrgPrivateLinkPolicy /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.aadiam/privateLinkForAzureAd/{policyName}
 * ```
 */
public class PrivateLinkForAzureAd internal constructor(
    override val javaResource: com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd,
) : KotlinCustomResource(javaResource, PrivateLinkForAzureAdMapper) {
    /**
     * Flag indicating whether all tenants are allowed
     */
    public val allTenants: Output<Boolean>?
        get() = javaResource.allTenants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of this resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Guid of the owner tenant
     */
    public val ownerTenantId: Output<String>?
        get() = javaResource.ownerTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource group
     */
    public val resourceGroup: Output<String>?
        get() = javaResource.resourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the private link policy resource
     */
    public val resourceName: Output<String>?
        get() = javaResource.resourceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription Identifier
     */
    public val subscriptionId: Output<String>?
        get() = javaResource.subscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The list of tenantIds.
     */
    public val tenants: Output<List<String>>?
        get() = javaResource.tenants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkForAzureAdMapper : ResourceMapper<PrivateLinkForAzureAd> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkForAzureAd =
        PrivateLinkForAzureAd(javaResource as com.pulumi.azurenative.aadiam.PrivateLinkForAzureAd)
}

/**
 * @see [PrivateLinkForAzureAd].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkForAzureAd].
 */
public suspend fun privateLinkForAzureAd(
    name: String,
    block: suspend PrivateLinkForAzureAdResourceBuilder.() -> Unit,
): PrivateLinkForAzureAd {
    val builder = PrivateLinkForAzureAdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkForAzureAd].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkForAzureAd(name: String): PrivateLinkForAzureAd {
    val builder = PrivateLinkForAzureAdResourceBuilder()
    builder.name(name)
    return builder.build()
}
