@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.GetPrivateLinkForAzureAdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyName The name of the private link policy in Azure AD.
 * @property resourceGroupName Name of an Azure resource group.
 */
public data class GetPrivateLinkForAzureAdPlainArgs(
    public val policyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.GetPrivateLinkForAzureAdPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.GetPrivateLinkForAzureAdPlainArgs =
        com.pulumi.azurenative.aadiam.inputs.GetPrivateLinkForAzureAdPlainArgs.builder()
            .policyName(policyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkForAzureAdPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkForAzureAdPlainArgsBuilder internal constructor() {
    private var policyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the private link policy in Azure AD.
     */
    @JvmName("pwvomntiaminhwca")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("ohpkpbppniailajs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateLinkForAzureAdPlainArgs = GetPrivateLinkForAzureAdPlainArgs(
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
