@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.advisor.kotlin

import com.pulumi.azurenative.advisor.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.advisor.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Suppression].
 */
@PulumiTagMarker
public class SuppressionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SuppressionArgs = SuppressionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SuppressionArgsBuilder.() -> Unit) {
        val builder = SuppressionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Suppression {
        val builtJavaResource = com.pulumi.azurenative.advisor.Suppression(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Suppression(builtJavaResource)
    }
}

/**
 * The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2016-07-12-preview.
 * ## Example Usage
 * ### CreateSuppression
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var suppression = new AzureNative.Advisor.Suppression("suppression", new()
 *     {
 *         Name = "suppressionName1",
 *         RecommendationId = "recommendationId",
 *         ResourceUri = "resourceUri",
 *         Ttl = "07:00:00:00",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/advisor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := advisor.NewSuppression(ctx, "suppression", &advisor.SuppressionArgs{
 * 			Name:             pulumi.String("suppressionName1"),
 * 			RecommendationId: pulumi.String("recommendationId"),
 * 			ResourceUri:      pulumi.String("resourceUri"),
 * 			Ttl:              pulumi.String("07:00:00:00"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.advisor.Suppression;
 * import com.pulumi.azurenative.advisor.SuppressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var suppression = new Suppression("suppression", SuppressionArgs.builder()
 *             .name("suppressionName1")
 *             .recommendationId("recommendationId")
 *             .resourceUri("resourceUri")
 *             .ttl("07:00:00:00")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:advisor:Suppression suppressionName1 /{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}
 * ```
 */
public class Suppression internal constructor(
    override val javaResource: com.pulumi.azurenative.advisor.Suppression,
) : KotlinCustomResource(javaResource, SuppressionMapper) {
    /**
     * Gets or sets the expiration time stamp.
     */
    public val expirationTimeStamp: Output<String>
        get() = javaResource.expirationTimeStamp().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The GUID of the suppression.
     */
    public val suppressionId: Output<String>?
        get() = javaResource.suppressionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The duration for which the suppression is valid.
     */
    public val ttl: Output<String>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SuppressionMapper : ResourceMapper<Suppression> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.advisor.Suppression::class == javaResource::class

    override fun map(javaResource: Resource): Suppression = Suppression(
        javaResource as
            com.pulumi.azurenative.advisor.Suppression,
    )
}

/**
 * @see [Suppression].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Suppression].
 */
public suspend fun suppression(name: String, block: suspend SuppressionResourceBuilder.() -> Unit):
    Suppression {
    val builder = SuppressionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Suppression].
 * @param name The _unique_ name of the resulting resource.
 */
public fun suppression(name: String): Suppression {
    val builder = SuppressionResourceBuilder()
    builder.name(name)
    return builder.build()
}
