@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.advisor.kotlin

import com.pulumi.azurenative.advisor.SuppressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2016-07-12-preview.
 * ## Example Usage
 * ### CreateSuppression
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var suppression = new AzureNative.Advisor.Suppression("suppression", new()
 *     {
 *         Name = "suppressionName1",
 *         RecommendationId = "recommendationId",
 *         ResourceUri = "resourceUri",
 *         Ttl = "07:00:00:00",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/advisor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := advisor.NewSuppression(ctx, "suppression", &advisor.SuppressionArgs{
 * 			Name:             pulumi.String("suppressionName1"),
 * 			RecommendationId: pulumi.String("recommendationId"),
 * 			ResourceUri:      pulumi.String("resourceUri"),
 * 			Ttl:              pulumi.String("07:00:00:00"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.advisor.Suppression;
 * import com.pulumi.azurenative.advisor.SuppressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var suppression = new Suppression("suppression", SuppressionArgs.builder()
 *             .name("suppressionName1")
 *             .recommendationId("recommendationId")
 *             .resourceUri("resourceUri")
 *             .ttl("07:00:00:00")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:advisor:Suppression suppressionName1 /{resourceUri}/providers/Microsoft.Advisor/recommendations/{recommendationId}/suppressions/{name}
 * ```
 * @property name The name of the suppression.
 * @property recommendationId The recommendation ID.
 * @property resourceUri The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
 * @property suppressionId The GUID of the suppression.
 * @property ttl The duration for which the suppression is valid.
 */
public data class SuppressionArgs(
    public val name: Output<String>? = null,
    public val recommendationId: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val suppressionId: Output<String>? = null,
    public val ttl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.advisor.SuppressionArgs> {
    override fun toJava(): com.pulumi.azurenative.advisor.SuppressionArgs =
        com.pulumi.azurenative.advisor.SuppressionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .recommendationId(recommendationId?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .suppressionId(suppressionId?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SuppressionArgs].
 */
@PulumiTagMarker
public class SuppressionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var recommendationId: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var suppressionId: Output<String>? = null

    private var ttl: Output<String>? = null

    /**
     * @param value The name of the suppression.
     */
    @JvmName("gdnnpawsearvuhnv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The recommendation ID.
     */
    @JvmName("wvncrvqmktnyykwx")
    public suspend fun recommendationId(`value`: Output<String>) {
        this.recommendationId = value
    }

    /**
     * @param value The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
     */
    @JvmName("pixpgjqwiysxngss")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The GUID of the suppression.
     */
    @JvmName("yanndbanajulljjx")
    public suspend fun suppressionId(`value`: Output<String>) {
        this.suppressionId = value
    }

    /**
     * @param value The duration for which the suppression is valid.
     */
    @JvmName("xdklcwudgvgwkofi")
    public suspend fun ttl(`value`: Output<String>) {
        this.ttl = value
    }

    /**
     * @param value The name of the suppression.
     */
    @JvmName("bklwsdxwveuexdna")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The recommendation ID.
     */
    @JvmName("lrjwcjvuhkeiifcu")
    public suspend fun recommendationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationId = mapped
    }

    /**
     * @param value The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
     */
    @JvmName("nyfgeeqqqsobdfpo")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The GUID of the suppression.
     */
    @JvmName("buecyqkjmnibsmpb")
    public suspend fun suppressionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionId = mapped
    }

    /**
     * @param value The duration for which the suppression is valid.
     */
    @JvmName("lquedpsbrtubigfv")
    public suspend fun ttl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): SuppressionArgs = SuppressionArgs(
        name = name,
        recommendationId = recommendationId,
        resourceUri = resourceUri,
        suppressionId = suppressionId,
        ttl = ttl,
    )
}
