@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.advisor.kotlin.inputs

import com.pulumi.azurenative.advisor.inputs.GetSuppressionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the suppression.
 * @property recommendationId The recommendation ID.
 * @property resourceUri The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
 */
public data class GetSuppressionPlainArgs(
    public val name: String,
    public val recommendationId: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.advisor.inputs.GetSuppressionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.advisor.inputs.GetSuppressionPlainArgs =
        com.pulumi.azurenative.advisor.inputs.GetSuppressionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .recommendationId(recommendationId.let({ args0 -> args0 }))
            .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSuppressionPlainArgs].
 */
@PulumiTagMarker
public class GetSuppressionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var recommendationId: String? = null

    private var resourceUri: String? = null

    /**
     * @param value The name of the suppression.
     */
    @JvmName("oyqstpvifoabhsyc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The recommendation ID.
     */
    @JvmName("qdrtmjqxwdmiobtc")
    public suspend fun recommendationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.recommendationId = mapped
    }

    /**
     * @param value The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
     */
    @JvmName("xutbcqngcsldsbdg")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetSuppressionPlainArgs = GetSuppressionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        recommendationId = recommendationId ?: throw PulumiNullFieldException("recommendationId"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
