@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.DataConnectorArgs.builder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.DataConnectorPropertiesArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.DataConnectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataConnector Model.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### DataConnectors_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataConnector = new AzureNative.AgFoodPlatform.DataConnector("dataConnector", new()
 *     {
 *         DataConnectorName = "WeatherIBM",
 *         DataManagerForAgricultureResourceName = "examples-dataManagerForAgricultureResourceName",
 *         Properties = new AzureNative.AgFoodPlatform.Inputs.DataConnectorPropertiesArgs
 *         {
 *             Credentials = new AzureNative.AgFoodPlatform.Inputs.ApiKeyAuthCredentialsArgs
 *             {
 *                 ApiKey = new AzureNative.AgFoodPlatform.Inputs.KeyVaultPropertiesArgs
 *                 {
 *                     KeyName = "abcApiKey",
 *                     KeyVaultUri = "https://testKeyVault.vault.azure.net/",
 *                     KeyVersion = "239c0475c7d44f20b0fc27d3fe90a41d",
 *                 },
 *                 Kind = "ApiKeyAuthCredentials",
 *             },
 *         },
 *         ResourceGroupName = "examples-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewDataConnector(ctx, "dataConnector", &agfoodplatform.DataConnectorArgs{
 * 			DataConnectorName:                     pulumi.String("WeatherIBM"),
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-dataManagerForAgricultureResourceName"),
 * 			Properties: agfoodplatform.DataConnectorPropertiesResponse{
 * 				Credentials: agfoodplatform.ApiKeyAuthCredentials{
 * 					ApiKey: agfoodplatform.KeyVaultProperties{
 * 						KeyName:     "abcApiKey",
 * 						KeyVaultUri: "https://testKeyVault.vault.azure.net/",
 * 						KeyVersion:  "239c0475c7d44f20b0fc27d3fe90a41d",
 * 					},
 * 					Kind: "ApiKeyAuthCredentials",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.DataConnector;
 * import com.pulumi.azurenative.agfoodplatform.DataConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataConnector = new DataConnector("dataConnector", DataConnectorArgs.builder()
 *             .dataConnectorName("WeatherIBM")
 *             .dataManagerForAgricultureResourceName("examples-dataManagerForAgricultureResourceName")
 *             .properties(Map.of("credentials", Map.ofEntries(
 *                 Map.entry("apiKey", Map.ofEntries(
 *                     Map.entry("keyName", "abcApiKey"),
 *                     Map.entry("keyVaultUri", "https://testKeyVault.vault.azure.net/"),
 *                     Map.entry("keyVersion", "239c0475c7d44f20b0fc27d3fe90a41d")
 *                 )),
 *                 Map.entry("kind", "ApiKeyAuthCredentials")
 *             )))
 *             .resourceGroupName("examples-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:DataConnector SatelliteSentinelHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/dataConnectors/{dataConnectorName}
 * ```
 * @property dataConnectorName Connector name.
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property properties DataConnector Properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DataConnectorArgs(
    public val dataConnectorName: Output<String>? = null,
    public val dataManagerForAgricultureResourceName: Output<String>? = null,
    public val properties: Output<DataConnectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.DataConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.DataConnectorArgs =
        com.pulumi.azurenative.agfoodplatform.DataConnectorArgs.builder()
            .dataConnectorName(dataConnectorName?.applyValue({ args0 -> args0 }))
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataConnectorArgs].
 */
@PulumiTagMarker
public class DataConnectorArgsBuilder internal constructor() {
    private var dataConnectorName: Output<String>? = null

    private var dataManagerForAgricultureResourceName: Output<String>? = null

    private var properties: Output<DataConnectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Connector name.
     */
    @JvmName("sgjjpsiaupsumovt")
    public suspend fun dataConnectorName(`value`: Output<String>) {
        this.dataConnectorName = value
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("xbfrmooyuqdnoebn")
    public suspend fun dataManagerForAgricultureResourceName(`value`: Output<String>) {
        this.dataManagerForAgricultureResourceName = value
    }

    /**
     * @param value DataConnector Properties.
     */
    @JvmName("lhojttaxutandhpt")
    public suspend fun properties(`value`: Output<DataConnectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jgnpdkjwkqmtbcbf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Connector name.
     */
    @JvmName("gqlmxcieuumyoufn")
    public suspend fun dataConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectorName = mapped
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("ibfspyliyxwsvato")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value DataConnector Properties.
     */
    @JvmName("pcgkllfqbdjbucma")
    public suspend fun properties(`value`: DataConnectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument DataConnector Properties.
     */
    @JvmName("spfrwgbwquwneapb")
    public suspend fun properties(argument: suspend DataConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataConnectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fbwfnuegcgwgunup")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DataConnectorArgs = DataConnectorArgs(
        dataConnectorName = dataConnectorName,
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
