@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.ExtensionArgs.builder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.ApiPropertiesArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.ApiPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Extension resource.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2020-05-12-preview.
 * Other available API versions: 2021-09-01-preview.
 * ## Example Usage
 * ### Extensions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.AgFoodPlatform.Extension("extension", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-dataManagerForAgricultureResourceName",
 *         ExtensionId = "provider.extension",
 *         ResourceGroupName = "examples-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewExtension(ctx, "extension", &agfoodplatform.ExtensionArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-dataManagerForAgricultureResourceName"),
 * 			ExtensionId:                           pulumi.String("provider.extension"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.Extension;
 * import com.pulumi.azurenative.agfoodplatform.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-dataManagerForAgricultureResourceName")
 *             .extensionId("provider.extension")
 *             .resourceGroupName("examples-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:Extension provider.extension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/extensions/{extensionId}
 * ```
 * @property additionalApiProperties Additional Api Properties.
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property extensionId Id of extension resource.
 * @property extensionVersion Extension Version.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ExtensionArgs(
    public val additionalApiProperties: Output<Map<String, ApiPropertiesArgs>>? = null,
    public val dataManagerForAgricultureResourceName: Output<String>? = null,
    public val extensionId: Output<String>? = null,
    public val extensionVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.ExtensionArgs =
        com.pulumi.azurenative.agfoodplatform.ExtensionArgs.builder()
            .additionalApiProperties(
                additionalApiProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .dataManagerForAgricultureResourceName(
                dataManagerForAgricultureResourceName?.applyValue({ args0 ->
                    args0
                }),
            )
            .extensionId(extensionId?.applyValue({ args0 -> args0 }))
            .extensionVersion(extensionVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var additionalApiProperties: Output<Map<String, ApiPropertiesArgs>>? = null

    private var dataManagerForAgricultureResourceName: Output<String>? = null

    private var extensionId: Output<String>? = null

    private var extensionVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Additional Api Properties.
     */
    @JvmName("dnergwraxqsdgjsl")
    public suspend fun additionalApiProperties(`value`: Output<Map<String, ApiPropertiesArgs>>) {
        this.additionalApiProperties = value
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("ikqdoixrmxfmwqxf")
    public suspend fun dataManagerForAgricultureResourceName(`value`: Output<String>) {
        this.dataManagerForAgricultureResourceName = value
    }

    /**
     * @param value Id of extension resource.
     */
    @JvmName("teljruvgwhvmiyyn")
    public suspend fun extensionId(`value`: Output<String>) {
        this.extensionId = value
    }

    /**
     * @param value Extension Version.
     */
    @JvmName("olffvomwwyrsgvul")
    public suspend fun extensionVersion(`value`: Output<String>) {
        this.extensionVersion = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odpsrkipbldxjmcx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Additional Api Properties.
     */
    @JvmName("vppgeydhabghselg")
    public suspend fun additionalApiProperties(`value`: Map<String, ApiPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalApiProperties = mapped
    }

    /**
     * @param argument Additional Api Properties.
     */
    @JvmName("thybhkpnpnknlpgq")
    public suspend fun additionalApiProperties(
        vararg
        argument: Pair<String, suspend ApiPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ApiPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.additionalApiProperties = mapped
    }

    /**
     * @param values Additional Api Properties.
     */
    @JvmName("chunlgkselgvblds")
    public fun additionalApiProperties(vararg values: Pair<String, ApiPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalApiProperties = mapped
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("dfneiqmypsffiwei")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value Id of extension resource.
     */
    @JvmName("ietuvxcihnqgicki")
    public suspend fun extensionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionId = mapped
    }

    /**
     * @param value Extension Version.
     */
    @JvmName("wwvtidmtfkqfocdy")
    public suspend fun extensionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionVersion = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("besxxdikhheyvaic")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        additionalApiProperties = additionalApiProperties,
        dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
        extensionId = extensionId,
        extensionVersion = extensionVersion,
        resourceGroupName = resourceGroupName,
    )
}
