@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.ApiPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Api properties.
 * @property apiFreshnessTimeInMinutes Interval in minutes for which the weather data for the api needs to be refreshed.
 */
public data class ApiPropertiesArgs(
    public val apiFreshnessTimeInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.ApiPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.ApiPropertiesArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.ApiPropertiesArgs.builder()
            .apiFreshnessTimeInMinutes(apiFreshnessTimeInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiPropertiesArgs].
 */
@PulumiTagMarker
public class ApiPropertiesArgsBuilder internal constructor() {
    private var apiFreshnessTimeInMinutes: Output<Int>? = null

    /**
     * @param value Interval in minutes for which the weather data for the api needs to be refreshed.
     */
    @JvmName("kqepdapoajdfwinm")
    public suspend fun apiFreshnessTimeInMinutes(`value`: Output<Int>) {
        this.apiFreshnessTimeInMinutes = value
    }

    /**
     * @param value Interval in minutes for which the weather data for the api needs to be refreshed.
     */
    @JvmName("hcohugdbptmoxkpg")
    public suspend fun apiFreshnessTimeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiFreshnessTimeInMinutes = mapped
    }

    internal fun build(): ApiPropertiesArgs = ApiPropertiesArgs(
        apiFreshnessTimeInMinutes = apiFreshnessTimeInMinutes,
    )
}
