@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Suppress

/**
 * DataConnector Properties.
 * @property credentials AuthCredentials abstract base class for Auth Purpose.
 */
public data class DataConnectorPropertiesResponse(
    public val credentials: Either<ApiKeyAuthCredentialsResponse, OAuthClientCredentialsResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.DataConnectorPropertiesResponse):
            DataConnectorPropertiesResponse = DataConnectorPropertiesResponse(
            credentials = javaType.credentials().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ApiKeyAuthCredentialsResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.agfoodplatform.kotlin.outputs.OAuthClientCredentialsResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
