@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.AlertProcessingRulePropertiesArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.AlertProcessingRulePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Alert processing rule object containing target scopes, conditions and scheduling logic.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a rule that adds alerts correlation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "CorrelateAlerts",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.CorrelateAlertsArgs
 *                 {
 *                     ActionType = "CorrelateAlerts",
 *                     CorrelateBy = new[]
 *                     {
 *                         new AzureNative.AlertsManagement.Inputs.CorrelateByArgs
 *                         {
 *                             Field = "essentials.alertRule",
 *                         },
 *                     },
 *                     CorrelationInterval = "PT30M",
 *                     NotificationsForCorrelatedAlerts = "SuppressAlways",
 *                     Priority = 50,
 *                 },
 *             },
 *             Description = "Correlate Alerts Example.",
 *             Enabled = true,
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * 			AlertProcessingRuleName: pulumi.String("CorrelateAlerts"),
 * 			Location:                pulumi.String("Global"),
 * 			Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * 				Actions: pulumi.Array{
 * 					alertsmanagement.CorrelateAlerts{
 * 						ActionType: "CorrelateAlerts",
 * 						CorrelateBy: []alertsmanagement.CorrelateBy{
 * 							{
 * 								Field: "essentials.alertRule",
 * 							},
 * 						},
 * 						CorrelationInterval:              "PT30M",
 * 						NotificationsForCorrelatedAlerts: "SuppressAlways",
 * 						Priority:                         50,
 * 					},
 * 				},
 * 				Description: pulumi.String("Correlate Alerts Example."),
 * 				Enabled:     pulumi.Bool(true),
 * 				Scopes: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/subId1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("CorrelateAlerts")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.ofEntries(
 *                     Map.entry("actionType", "CorrelateAlerts"),
 *                     Map.entry("correlateBy", Map.of("field", "essentials.alertRule")),
 *                     Map.entry("correlationInterval", "PT30M"),
 *                     Map.entry("notificationsForCorrelatedAlerts", "SuppressAlways"),
 *                     Map.entry("priority", 50)
 *                 )),
 *                 Map.entry("description", "Correlate Alerts Example."),
 *                 Map.entry("enabled", true),
 *                 Map.entry("scopes", "/subscriptions/subId1")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that adds an action group to all alerts in a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "AddActionGroupToSubscription",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.AddActionGroupsArgs
 *                 {
 *                     ActionGroupIds = new[]
 *                     {
 *                         "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/ActionGroup1",
 *                     },
 *                     ActionType = "AddActionGroups",
 *                 },
 *             },
 *             Description = "Add ActionGroup1 to all alerts in the subscription",
 *             Enabled = true,
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * 			AlertProcessingRuleName: pulumi.String("AddActionGroupToSubscription"),
 * 			Location:                pulumi.String("Global"),
 * 			Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * 				Actions: pulumi.Array{
 * 					alertsmanagement.AddActionGroups{
 * 						ActionGroupIds: []string{
 * 							"/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/ActionGroup1",
 * 						},
 * 						ActionType: "AddActionGroups",
 * 					},
 * 				},
 * 				Description: pulumi.String("Add ActionGroup1 to all alerts in the subscription"),
 * 				Enabled:     pulumi.Bool(true),
 * 				Scopes: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/subId1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("AddActionGroupToSubscription")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.ofEntries(
 *                     Map.entry("actionGroupIds", "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/ActionGroup1"),
 *                     Map.entry("actionType", "AddActionGroups")
 *                 )),
 *                 Map.entry("description", "Add ActionGroup1 to all alerts in the subscription"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("scopes", "/subscriptions/subId1")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that adds two action groups to all Sev0 and Sev1 alerts in two resource groups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "AddActionGroupsBySeverity",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.AddActionGroupsArgs
 *                 {
 *                     ActionGroupIds = new[]
 *                     {
 *                         "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId1",
 *                         "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId2",
 *                     },
 *                     ActionType = "AddActionGroups",
 *                 },
 *             },
 *             Conditions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Field = "Severity",
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "sev0",
 *                         "sev1",
 *                     },
 *                 },
 *             },
 *             Description = "Add AGId1 and AGId2 to all Sev0 and Sev1 alerts in these resourceGroups",
 *             Enabled = true,
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1/resourceGroups/RGId1",
 *                 "/subscriptions/subId1/resourceGroups/RGId2",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * 			AlertProcessingRuleName: pulumi.String("AddActionGroupsBySeverity"),
 * 			Location:                pulumi.String("Global"),
 * 			Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * 				Actions: pulumi.Array{
 * 					alertsmanagement.AddActionGroups{
 * 						ActionGroupIds: []string{
 * 							"/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId1",
 * 							"/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId2",
 * 						},
 * 						ActionType: "AddActionGroups",
 * 					},
 * 				},
 * 				Conditions: alertsmanagement.ConditionArray{
 * 					&alertsmanagement.ConditionArgs{
 * 						Field:    pulumi.String("Severity"),
 * 						Operator: pulumi.String("Equals"),
 * 						Values: pulumi.StringArray{
 * 							pulumi.String("sev0"),
 * 							pulumi.String("sev1"),
 * 						},
 * 					},
 * 				},
 * 				Description: pulumi.String("Add AGId1 and AGId2 to all Sev0 and Sev1 alerts in these resourceGroups"),
 * 				Enabled:     pulumi.Bool(true),
 * 				Scopes: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/subId1/resourceGroups/RGId1"),
 * 					pulumi.String("/subscriptions/subId1/resourceGroups/RGId2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("AddActionGroupsBySeverity")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.ofEntries(
 *                     Map.entry("actionGroupIds",
 *                         "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId1",
 *                         "/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId2"),
 *                     Map.entry("actionType", "AddActionGroups")
 *                 )),
 *                 Map.entry("conditions", Map.ofEntries(
 *                     Map.entry("field", "Severity"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("values",
 *                         "sev0",
 *                         "sev1")
 *                 )),
 *                 Map.entry("description", "Add AGId1 and AGId2 to all Sev0 and Sev1 alerts in these resourceGroups"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("scopes",
 *                     "/subscriptions/subId1/resourceGroups/RGId1",
 *                     "/subscriptions/subId1/resourceGroups/RGId2")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that removes all action groups from alerts on a specific VM during a one-off maintenance window (1800-2000 at a specific date, Pacific Standard Time)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "RemoveActionGroupsMaintenanceWindow",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.RemoveAllActionGroupsArgs
 *                 {
 *                     ActionType = "RemoveAllActionGroups",
 *                 },
 *             },
 *             Description = "Removes all ActionGroups from all Alerts on VMName during the maintenance window",
 *             Enabled = true,
 *             Schedule = new AzureNative.AlertsManagement.Inputs.ScheduleArgs
 *             {
 *                 EffectiveFrom = "2021-04-15T18:00:00",
 *                 EffectiveUntil = "2021-04-15T20:00:00",
 *                 TimeZone = "Pacific Standard Time",
 *             },
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1/resourceGroups/RGId1/providers/Microsoft.Compute/virtualMachines/VMName",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * 			AlertProcessingRuleName: pulumi.String("RemoveActionGroupsMaintenanceWindow"),
 * 			Location:                pulumi.String("Global"),
 * 			Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * 				Actions: pulumi.Array{
 * 					alertsmanagement.RemoveAllActionGroups{
 * 						ActionType: "RemoveAllActionGroups",
 * 					},
 * 				},
 * 				Description: pulumi.String("Removes all ActionGroups from all Alerts on VMName during the maintenance window"),
 * 				Enabled:     pulumi.Bool(true),
 * 				Schedule: &alertsmanagement.ScheduleArgs{
 * 					EffectiveFrom:  pulumi.String("2021-04-15T18:00:00"),
 * 					EffectiveUntil: pulumi.String("2021-04-15T20:00:00"),
 * 					TimeZone:       pulumi.String("Pacific Standard Time"),
 * 				},
 * 				Scopes: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/subId1/resourceGroups/RGId1/providers/Microsoft.Compute/virtualMachines/VMName"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("RemoveActionGroupsMaintenanceWindow")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.of("actionType", "RemoveAllActionGroups")),
 *                 Map.entry("description", "Removes all ActionGroups from all Alerts on VMName during the maintenance window"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("schedule", Map.ofEntries(
 *                     Map.entry("effectiveFrom", "2021-04-15T18:00:00"),
 *                     Map.entry("effectiveUntil", "2021-04-15T20:00:00"),
 *                     Map.entry("timeZone", "Pacific Standard Time")
 *                 )),
 *                 Map.entry("scopes", "/subscriptions/subId1/resourceGroups/RGId1/providers/Microsoft.Compute/virtualMachines/VMName")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that removes all action groups from all alerts in a subscription coming from a specific alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "RemoveActionGroupsSpecificAlertRule",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.RemoveAllActionGroupsArgs
 *                 {
 *                     ActionType = "RemoveAllActionGroups",
 *                 },
 *             },
 *             Conditions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Field = "AlertRuleId",
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "/subscriptions/suubId1/resourceGroups/Rgid2/providers/microsoft.insights/activityLogAlerts/RuleName",
 *                     },
 *                 },
 *             },
 *             Description = "Removes all ActionGroups from all Alerts that fire on above AlertRule",
 *             Enabled = true,
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * 			AlertProcessingRuleName: pulumi.String("RemoveActionGroupsSpecificAlertRule"),
 * 			Location:                pulumi.String("Global"),
 * 			Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * 				Actions: pulumi.Array{
 * 					alertsmanagement.RemoveAllActionGroups{
 * 						ActionType: "RemoveAllActionGroups",
 * 					},
 * 				},
 * 				Conditions: alertsmanagement.ConditionArray{
 * 					&alertsmanagement.ConditionArgs{
 * 						Field:    pulumi.String("AlertRuleId"),
 * 						Operator: pulumi.String("Equals"),
 * 						Values: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/suubId1/resourceGroups/Rgid2/providers/microsoft.insights/activityLogAlerts/RuleName"),
 * 						},
 * 					},
 * 				},
 * 				Description: pulumi.String("Removes all ActionGroups from all Alerts that fire on above AlertRule"),
 * 				Enabled:     pulumi.Bool(true),
 * 				Scopes: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/subId1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("RemoveActionGroupsSpecificAlertRule")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.of("actionType", "RemoveAllActionGroups")),
 *                 Map.entry("conditions", Map.ofEntries(
 *                     Map.entry("field", "AlertRuleId"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("values", "/subscriptions/suubId1/resourceGroups/Rgid2/providers/microsoft.insights/activityLogAlerts/RuleName")
 *                 )),
 *                 Map.entry("description", "Removes all ActionGroups from all Alerts that fire on above AlertRule"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("scopes", "/subscriptions/subId1")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that removes all action groups from all alerts on any VM in two resource groups during a recurring maintenance window (2200-0400 every Sat and Sun, India Standard Time)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "RemoveActionGroupsRecurringMaintenance",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.RemoveAllActionGroupsArgs
 *                 {
 *                     ActionType = "RemoveAllActionGroups",
 *                 },
 *             },
 *             Conditions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.ConditionArgs
 *                 {
 *                     Field = "TargetResourceType",
 *                     Operator = "Equals",
 *                     Values = new[]
 *                     {
 *                         "microsoft.compute/virtualmachines",
 *                     },
 *                 },
 *             },
 *             Description = "Remove all ActionGroups from all Vitual machine Alerts during the recurring maintenance",
 *             Enabled = true,
 *             Schedule = new AzureNative.AlertsManagement.Inputs.ScheduleArgs
 *             {
 *                 Recurrences = new[]
 *                 {
 *                     new AzureNative.AlertsManagement.Inputs.WeeklyRecurrenceArgs
 *                     {
 *                         DaysOfWeek = new[]
 *                         {
 *                             "Saturday",
 *                             "Sunday",
 *                         },
 *                         EndTime = "04:00:00",
 *                         RecurrenceType = "Weekly",
 *                         StartTime = "22:00:00",
 *                     },
 *                 },
 *                 TimeZone = "India Standard Time",
 *             },
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1/resourceGroups/RGId1",
 *                 "/subscriptions/subId1/resourceGroups/RGId2",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * AlertProcessingRuleName: pulumi.String("RemoveActionGroupsRecurringMaintenance"),
 * Location: pulumi.String("Global"),
 * Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * Actions: pulumi.Array{
 * alertsmanagement.RemoveAllActionGroups{
 * ActionType: "RemoveAllActionGroups",
 * },
 * },
 * Conditions: alertsmanagement.ConditionArray{
 * &alertsmanagement.ConditionArgs{
 * Field: pulumi.String("TargetResourceType"),
 * Operator: pulumi.String("Equals"),
 * Values: pulumi.StringArray{
 * pulumi.String("microsoft.compute/virtualmachines"),
 * },
 * },
 * },
 * Description: pulumi.String("Remove all ActionGroups from all Vitual machine Alerts during the recurring maintenance"),
 * Enabled: pulumi.Bool(true),
 * Schedule: interface{}{
 * Recurrences: pulumi.Array{
 * alertsmanagement.WeeklyRecurrence{
 * DaysOfWeek: []alertsmanagement.DaysOfWeek{
 * "Saturday",
 * "Sunday",
 * },
 * EndTime: "04:00:00",
 * RecurrenceType: "Weekly",
 * StartTime: "22:00:00",
 * },
 * },
 * TimeZone: pulumi.String("India Standard Time"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/subId1/resourceGroups/RGId1"),
 * pulumi.String("/subscriptions/subId1/resourceGroups/RGId2"),
 * },
 * },
 * ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("RemoveActionGroupsRecurringMaintenance")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.of("actionType", "RemoveAllActionGroups")),
 *                 Map.entry("conditions", Map.ofEntries(
 *                     Map.entry("field", "TargetResourceType"),
 *                     Map.entry("operator", "Equals"),
 *                     Map.entry("values", "microsoft.compute/virtualmachines")
 *                 )),
 *                 Map.entry("description", "Remove all ActionGroups from all Vitual machine Alerts during the recurring maintenance"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("schedule", Map.ofEntries(
 *                     Map.entry("recurrences", Map.ofEntries(
 *                         Map.entry("daysOfWeek",
 *                             "Saturday",
 *                             "Sunday"),
 *                         Map.entry("endTime", "04:00:00"),
 *                         Map.entry("recurrenceType", "Weekly"),
 *                         Map.entry("startTime", "22:00:00")
 *                     )),
 *                     Map.entry("timeZone", "India Standard Time")
 *                 )),
 *                 Map.entry("scopes",
 *                     "/subscriptions/subId1/resourceGroups/RGId1",
 *                     "/subscriptions/subId1/resourceGroups/RGId2")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a rule that removes all action groups outside business hours (Mon-Fri 09:00-17:00, Eastern Standard Time)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertProcessingRuleByName = new AzureNative.AlertsManagement.AlertProcessingRuleByName("alertProcessingRuleByName", new()
 *     {
 *         AlertProcessingRuleName = "RemoveActionGroupsOutsideBusinessHours",
 *         Location = "Global",
 *         Properties = new AzureNative.AlertsManagement.Inputs.AlertProcessingRulePropertiesArgs
 *         {
 *             Actions = new[]
 *             {
 *                 new AzureNative.AlertsManagement.Inputs.RemoveAllActionGroupsArgs
 *                 {
 *                     ActionType = "RemoveAllActionGroups",
 *                 },
 *             },
 *             Description = "Remove all ActionGroups outside business hours",
 *             Enabled = true,
 *             Schedule = new AzureNative.AlertsManagement.Inputs.ScheduleArgs
 *             {
 *                 Recurrences =
 *                 {
 *                     new AzureNative.AlertsManagement.Inputs.DailyRecurrenceArgs
 *                     {
 *                         EndTime = "09:00:00",
 *                         RecurrenceType = "Daily",
 *                         StartTime = "17:00:00",
 *                     },
 *                     new AzureNative.AlertsManagement.Inputs.WeeklyRecurrenceArgs
 *                     {
 *                         DaysOfWeek = new[]
 *                         {
 *                             "Saturday",
 *                             "Sunday",
 *                         },
 *                         RecurrenceType = "Weekly",
 *                     },
 *                 },
 *                 TimeZone = "Eastern Standard Time",
 *             },
 *             Scopes = new[]
 *             {
 *                 "/subscriptions/subId1",
 *             },
 *         },
 *         ResourceGroupName = "alertscorrelationrg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := alertsmanagement.NewAlertProcessingRuleByName(ctx, "alertProcessingRuleByName", &alertsmanagement.AlertProcessingRuleByNameArgs{
 * AlertProcessingRuleName: pulumi.String("RemoveActionGroupsOutsideBusinessHours"),
 * Location: pulumi.String("Global"),
 * Properties: alertsmanagement.AlertProcessingRulePropertiesResponse{
 * Actions: pulumi.Array{
 * alertsmanagement.RemoveAllActionGroups{
 * ActionType: "RemoveAllActionGroups",
 * },
 * },
 * Description: pulumi.String("Remove all ActionGroups outside business hours"),
 * Enabled: pulumi.Bool(true),
 * Schedule: interface{}{
 * Recurrences: pulumi.Array{
 * alertsmanagement.DailyRecurrence{
 * EndTime: "09:00:00",
 * RecurrenceType: "Daily",
 * StartTime: "17:00:00",
 * },
 * alertsmanagement.WeeklyRecurrence{
 * DaysOfWeek: []alertsmanagement.DaysOfWeek{
 * "Saturday",
 * "Sunday",
 * },
 * RecurrenceType: "Weekly",
 * },
 * },
 * TimeZone: pulumi.String("Eastern Standard Time"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/subId1"),
 * },
 * },
 * ResourceGroupName: pulumi.String("alertscorrelationrg"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByName;
 * import com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertProcessingRuleByName = new AlertProcessingRuleByName("alertProcessingRuleByName", AlertProcessingRuleByNameArgs.builder()
 *             .alertProcessingRuleName("RemoveActionGroupsOutsideBusinessHours")
 *             .location("Global")
 *             .properties(Map.ofEntries(
 *                 Map.entry("actions", Map.of("actionType", "RemoveAllActionGroups")),
 *                 Map.entry("description", "Remove all ActionGroups outside business hours"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("schedule", Map.ofEntries(
 *                     Map.entry("recurrences",
 *                         Map.ofEntries(
 *                             Map.entry("endTime", "09:00:00"),
 *                             Map.entry("recurrenceType", "Daily"),
 *                             Map.entry("startTime", "17:00:00")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("daysOfWeek",
 *                                 "Saturday",
 *                                 "Sunday"),
 *                             Map.entry("recurrenceType", "Weekly")
 *                         )),
 *                     Map.entry("timeZone", "Eastern Standard Time")
 *                 )),
 *                 Map.entry("scopes", "/subscriptions/subId1")
 *             ))
 *             .resourceGroupName("alertscorrelationrg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:AlertProcessingRuleByName RemoveActionGroupsOutsideBusinessHours /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}
 * ```
 * @property alertProcessingRuleName The name of the alert processing rule that needs to be created/updated.
 * @property location Resource location
 * @property properties Alert processing rule properties.
 * @property resourceGroupName Resource group name where the resource is created.
 * @property tags Resource tags
 */
public data class AlertProcessingRuleByNameArgs(
    public val alertProcessingRuleName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AlertProcessingRulePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs =
        com.pulumi.azurenative.alertsmanagement.AlertProcessingRuleByNameArgs.builder()
            .alertProcessingRuleName(alertProcessingRuleName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AlertProcessingRuleByNameArgs].
 */
@PulumiTagMarker
public class AlertProcessingRuleByNameArgsBuilder internal constructor() {
    private var alertProcessingRuleName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<AlertProcessingRulePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the alert processing rule that needs to be created/updated.
     */
    @JvmName("tgtciqarqwidlfcj")
    public suspend fun alertProcessingRuleName(`value`: Output<String>) {
        this.alertProcessingRuleName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("dwfhjvghdippmote")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Alert processing rule properties.
     */
    @JvmName("jccenwretybescmd")
    public suspend fun properties(`value`: Output<AlertProcessingRulePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("efhsnsmmnoiajwva")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jprjammwumnfwyhg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the alert processing rule that needs to be created/updated.
     */
    @JvmName("tcauckkpxmqlppgj")
    public suspend fun alertProcessingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertProcessingRuleName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("bpflblglyvutkxbt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Alert processing rule properties.
     */
    @JvmName("vafjoguiyhkfnvhx")
    public suspend fun properties(`value`: AlertProcessingRulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Alert processing rule properties.
     */
    @JvmName("suckxynsvhvvervu")
    public suspend
    fun properties(argument: suspend AlertProcessingRulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AlertProcessingRulePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Resource group name where the resource is created.
     */
    @JvmName("vxhlqdeatvsuyihw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("lfjixvmvdcdanfog")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("gvygtqqdalnlvkan")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AlertProcessingRuleByNameArgs = AlertProcessingRuleByNameArgs(
        alertProcessingRuleName = alertProcessingRuleName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
