@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.AlertsmanagementFunctions.getActionRuleByNamePlain
import com.pulumi.azurenative.alertsmanagement.AlertsmanagementFunctions.getAlertProcessingRuleByNamePlain
import com.pulumi.azurenative.alertsmanagement.AlertsmanagementFunctions.getPrometheusRuleGroupPlain
import com.pulumi.azurenative.alertsmanagement.AlertsmanagementFunctions.getSmartDetectorAlertRulePlain
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetActionRuleByNamePlainArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetActionRuleByNamePlainArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetAlertProcessingRuleByNamePlainArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetAlertProcessingRuleByNamePlainArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetPrometheusRuleGroupPlainArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetPrometheusRuleGroupPlainArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetSmartDetectorAlertRulePlainArgs
import com.pulumi.azurenative.alertsmanagement.kotlin.inputs.GetSmartDetectorAlertRulePlainArgsBuilder
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetActionRuleByNameResult
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetAlertProcessingRuleByNameResult
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetPrometheusRuleGroupResult
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetSmartDetectorAlertRuleResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetActionRuleByNameResult.Companion.toKotlin as getActionRuleByNameResultToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetAlertProcessingRuleByNameResult.Companion.toKotlin as getAlertProcessingRuleByNameResultToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetPrometheusRuleGroupResult.Companion.toKotlin as getPrometheusRuleGroupResultToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.GetSmartDetectorAlertRuleResult.Companion.toKotlin as getSmartDetectorAlertRuleResultToKotlin

public object AlertsmanagementFunctions {
    /**
     * Get a specific action rule
     * Azure REST API version: 2019-05-05-preview.
     * Other available API versions: 2018-11-02-privatepreview.
     * @param argument null
     * @return Action rule object containing target scope, conditions and suppression logic
     */
    public suspend fun getActionRuleByName(argument: GetActionRuleByNamePlainArgs):
        GetActionRuleByNameResult =
        getActionRuleByNameResultToKotlin(getActionRuleByNamePlain(argument.toJava()).await())

    /**
     * @see [getActionRuleByName].
     * @param actionRuleName The name of action rule that needs to be fetched
     * @param resourceGroupName Resource group name where the resource is created.
     * @return Action rule object containing target scope, conditions and suppression logic
     */
    public suspend fun getActionRuleByName(actionRuleName: String, resourceGroupName: String):
        GetActionRuleByNameResult {
        val argument = GetActionRuleByNamePlainArgs(
            actionRuleName = actionRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getActionRuleByNameResultToKotlin(getActionRuleByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getActionRuleByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;alertsmanagement&#46;kotlin&#46;inputs&#46;GetActionRuleByNamePlainArgs].
     * @return Action rule object containing target scope, conditions and suppression logic
     */
    public suspend
    fun getActionRuleByName(argument: suspend GetActionRuleByNamePlainArgsBuilder.() -> Unit):
        GetActionRuleByNameResult {
        val builder = GetActionRuleByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActionRuleByNameResultToKotlin(getActionRuleByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Get an alert processing rule by name.
     * Azure REST API version: 2023-05-01-preview.
     * @param argument null
     * @return Alert processing rule object containing target scopes, conditions and scheduling logic.
     */
    public suspend fun getAlertProcessingRuleByName(argument: GetAlertProcessingRuleByNamePlainArgs):
        GetAlertProcessingRuleByNameResult =
        getAlertProcessingRuleByNameResultToKotlin(getAlertProcessingRuleByNamePlain(argument.toJava()).await())

    /**
     * @see [getAlertProcessingRuleByName].
     * @param alertProcessingRuleName The name of the alert processing rule that needs to be fetched.
     * @param resourceGroupName Resource group name where the resource is created.
     * @return Alert processing rule object containing target scopes, conditions and scheduling logic.
     */
    public suspend fun getAlertProcessingRuleByName(
        alertProcessingRuleName: String,
        resourceGroupName: String,
    ): GetAlertProcessingRuleByNameResult {
        val argument = GetAlertProcessingRuleByNamePlainArgs(
            alertProcessingRuleName = alertProcessingRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getAlertProcessingRuleByNameResultToKotlin(getAlertProcessingRuleByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertProcessingRuleByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;alertsmanagement&#46;kotlin&#46;inputs&#46;GetAlertProcessingRuleByNamePlainArgs].
     * @return Alert processing rule object containing target scopes, conditions and scheduling logic.
     */
    public suspend
    fun getAlertProcessingRuleByName(argument: suspend GetAlertProcessingRuleByNamePlainArgsBuilder.() -> Unit):
        GetAlertProcessingRuleByNameResult {
        val builder = GetAlertProcessingRuleByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertProcessingRuleByNameResultToKotlin(getAlertProcessingRuleByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve a Prometheus rule group definition.
     * Azure REST API version: 2023-03-01.
     * @param argument null
     * @return The Prometheus rule group resource.
     */
    public suspend fun getPrometheusRuleGroup(argument: GetPrometheusRuleGroupPlainArgs):
        GetPrometheusRuleGroupResult =
        getPrometheusRuleGroupResultToKotlin(getPrometheusRuleGroupPlain(argument.toJava()).await())

    /**
     * @see [getPrometheusRuleGroup].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleGroupName The name of the rule group.
     * @return The Prometheus rule group resource.
     */
    public suspend fun getPrometheusRuleGroup(resourceGroupName: String, ruleGroupName: String):
        GetPrometheusRuleGroupResult {
        val argument = GetPrometheusRuleGroupPlainArgs(
            resourceGroupName = resourceGroupName,
            ruleGroupName = ruleGroupName,
        )
        return getPrometheusRuleGroupResultToKotlin(getPrometheusRuleGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrometheusRuleGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;alertsmanagement&#46;kotlin&#46;inputs&#46;GetPrometheusRuleGroupPlainArgs].
     * @return The Prometheus rule group resource.
     */
    public suspend
    fun getPrometheusRuleGroup(argument: suspend GetPrometheusRuleGroupPlainArgsBuilder.() -> Unit):
        GetPrometheusRuleGroupResult {
        val builder = GetPrometheusRuleGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrometheusRuleGroupResultToKotlin(getPrometheusRuleGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific Smart Detector alert rule.
     * Azure REST API version: 2021-04-01.
     * @param argument null
     * @return The alert rule information
     */
    public suspend fun getSmartDetectorAlertRule(argument: GetSmartDetectorAlertRulePlainArgs):
        GetSmartDetectorAlertRuleResult =
        getSmartDetectorAlertRuleResultToKotlin(getSmartDetectorAlertRulePlain(argument.toJava()).await())

    /**
     * @see [getSmartDetectorAlertRule].
     * @param alertRuleName The name of the alert rule.
     * @param expandDetector Indicates if Smart Detector should be expanded.
     * @param resourceGroupName The name of the resource group.
     * @return The alert rule information
     */
    public suspend fun getSmartDetectorAlertRule(
        alertRuleName: String,
        expandDetector: Boolean? = null,
        resourceGroupName: String,
    ): GetSmartDetectorAlertRuleResult {
        val argument = GetSmartDetectorAlertRulePlainArgs(
            alertRuleName = alertRuleName,
            expandDetector = expandDetector,
            resourceGroupName = resourceGroupName,
        )
        return getSmartDetectorAlertRuleResultToKotlin(getSmartDetectorAlertRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSmartDetectorAlertRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;alertsmanagement&#46;kotlin&#46;inputs&#46;GetSmartDetectorAlertRulePlainArgs].
     * @return The alert rule information
     */
    public suspend
    fun getSmartDetectorAlertRule(argument: suspend GetSmartDetectorAlertRulePlainArgsBuilder.() -> Unit):
        GetSmartDetectorAlertRuleResult {
        val builder = GetSmartDetectorAlertRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSmartDetectorAlertRuleResultToKotlin(getSmartDetectorAlertRulePlain(builtArgument.toJava()).await())
    }
}
