@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin

import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ActionGroupsInformationResponse
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.DetectorResponse
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ThrottlingInformationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ActionGroupsInformationResponse.Companion.toKotlin as actionGroupsInformationResponseToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.DetectorResponse.Companion.toKotlin as detectorResponseToKotlin
import com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ThrottlingInformationResponse.Companion.toKotlin as throttlingInformationResponseToKotlin

/**
 * Builder for [SmartDetectorAlertRule].
 */
@PulumiTagMarker
public class SmartDetectorAlertRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SmartDetectorAlertRuleArgs = SmartDetectorAlertRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SmartDetectorAlertRuleArgsBuilder.() -> Unit) {
        val builder = SmartDetectorAlertRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SmartDetectorAlertRule {
        val builtJavaResource =
            com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SmartDetectorAlertRule(builtJavaResource)
    }
}

/**
 * The alert rule information
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### Create or update a Smart Detector alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var smartDetectorAlertRule = new AzureNative.AlertsManagement.SmartDetectorAlertRule("smartDetectorAlertRule", new()
 *     {
 *         ActionGroups = new AzureNative.AlertsManagement.Inputs.ActionGroupsInformationArgs
 *         {
 *             CustomEmailSubject = "My custom email subject",
 *             CustomWebhookPayload = "{\"AlertRuleName\":\"#alertrulename\"}",
 *             GroupIds = new[]
 *             {
 *                 "/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup",
 *             },
 *         },
 *         AlertRuleName = "MyAlertRule",
 *         Description = "Sample smart detector alert rule description",
 *         Detector = new AzureNative.AlertsManagement.Inputs.DetectorArgs
 *         {
 *             Id = "VMMemoryLeak",
 *         },
 *         Frequency = "PT5M",
 *         ResourceGroupName = "MyAlertRules",
 *         Scope = new[]
 *         {
 *             "/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1",
 *         },
 *         Severity = "Sev3",
 *         State = "Enabled",
 *         Throttling = new AzureNative.AlertsManagement.Inputs.ThrottlingInformationArgs
 *         {
 *             Duration = "PT20M",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/alertsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := alertsmanagement.NewSmartDetectorAlertRule(ctx, "smartDetectorAlertRule", &alertsmanagement.SmartDetectorAlertRuleArgs{
 * 			ActionGroups: &alertsmanagement.ActionGroupsInformationArgs{
 * 				CustomEmailSubject:   pulumi.String("My custom email subject"),
 * 				CustomWebhookPayload: pulumi.String("{\"AlertRuleName\":\"#alertrulename\"}"),
 * 				GroupIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup"),
 * 				},
 * 			},
 * 			AlertRuleName: pulumi.String("MyAlertRule"),
 * 			Description:   pulumi.String("Sample smart detector alert rule description"),
 * 			Detector: &alertsmanagement.DetectorArgs{
 * 				Id: pulumi.String("VMMemoryLeak"),
 * 			},
 * 			Frequency:         pulumi.String("PT5M"),
 * 			ResourceGroupName: pulumi.String("MyAlertRules"),
 * 			Scope: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 			},
 * 			Severity: pulumi.String("Sev3"),
 * 			State:    pulumi.String("Enabled"),
 * 			Throttling: &alertsmanagement.ThrottlingInformationArgs{
 * 				Duration: pulumi.String("PT20M"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule;
 * import com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var smartDetectorAlertRule = new SmartDetectorAlertRule("smartDetectorAlertRule", SmartDetectorAlertRuleArgs.builder()
 *             .actionGroups(Map.ofEntries(
 *                 Map.entry("customEmailSubject", "My custom email subject"),
 *                 Map.entry("customWebhookPayload", "{\"AlertRuleName\":\"#alertrulename\"}"),
 *                 Map.entry("groupIds", "/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourcegroups/actionGroups/providers/microsoft.insights/actiongroups/MyActionGroup")
 *             ))
 *             .alertRuleName("MyAlertRule")
 *             .description("Sample smart detector alert rule description")
 *             .detector(Map.of("id", "VMMemoryLeak"))
 *             .frequency("PT5M")
 *             .resourceGroupName("MyAlertRules")
 *             .scope("/subscriptions/b368ca2f-e298-46b7-b0ab-012281956afa/resourceGroups/MyVms/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .severity("Sev3")
 *             .state("Enabled")
 *             .throttling(Map.of("duration", "PT20M"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:alertsmanagement:SmartDetectorAlertRule MyAlertRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.alertsManagement/smartDetectorAlertRules/{alertRuleName}
 * ```
 */
public class SmartDetectorAlertRule internal constructor(
    override val javaResource: com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule,
) : KotlinCustomResource(javaResource, SmartDetectorAlertRuleMapper) {
    /**
     * The alert rule actions.
     */
    public val actionGroups: Output<ActionGroupsInformationResponse>
        get() = javaResource.actionGroups().applyValue({ args0 ->
            args0.let({ args0 ->
                actionGroupsInformationResponseToKotlin(args0)
            })
        })

    /**
     * The alert rule description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The alert rule's detector.
     */
    public val detector: Output<DetectorResponse>
        get() = javaResource.detector().applyValue({ args0 ->
            args0.let({ args0 ->
                detectorResponseToKotlin(args0)
            })
        })

    /**
     * The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 1 minute, depending on the detector.
     */
    public val frequency: Output<String>
        get() = javaResource.frequency().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The alert rule resources scope.
     */
    public val scope: Output<List<String>>
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The alert rule severity.
     */
    public val severity: Output<String>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    /**
     * The alert rule state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The alert rule throttling information.
     */
    public val throttling: Output<ThrottlingInformationResponse>?
        get() = javaResource.throttling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    throttlingInformationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SmartDetectorAlertRuleMapper : ResourceMapper<SmartDetectorAlertRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule::class == javaResource::class

    override fun map(javaResource: Resource): SmartDetectorAlertRule =
        SmartDetectorAlertRule(
            javaResource as
                com.pulumi.azurenative.alertsmanagement.SmartDetectorAlertRule,
        )
}

/**
 * @see [SmartDetectorAlertRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SmartDetectorAlertRule].
 */
public suspend fun smartDetectorAlertRule(
    name: String,
    block: suspend SmartDetectorAlertRuleResourceBuilder.() -> Unit,
): SmartDetectorAlertRule {
    val builder = SmartDetectorAlertRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SmartDetectorAlertRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun smartDetectorAlertRule(name: String): SmartDetectorAlertRule {
    val builder = SmartDetectorAlertRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
