@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Field for a given condition.
 */
public enum class Field(
    public val javaValue: com.pulumi.azurenative.alertsmanagement.enums.Field,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.enums.Field> {
    Severity(com.pulumi.azurenative.alertsmanagement.enums.Field.Severity),
    MonitorService(com.pulumi.azurenative.alertsmanagement.enums.Field.MonitorService),
    MonitorCondition(com.pulumi.azurenative.alertsmanagement.enums.Field.MonitorCondition),
    SignalType(com.pulumi.azurenative.alertsmanagement.enums.Field.SignalType),
    TargetResourceType(com.pulumi.azurenative.alertsmanagement.enums.Field.TargetResourceType),
    TargetResource(com.pulumi.azurenative.alertsmanagement.enums.Field.TargetResource),
    TargetResourceGroup(com.pulumi.azurenative.alertsmanagement.enums.Field.TargetResourceGroup),
    AlertRuleId(com.pulumi.azurenative.alertsmanagement.enums.Field.AlertRuleId),
    AlertRuleName(com.pulumi.azurenative.alertsmanagement.enums.Field.AlertRuleName),
    Description(com.pulumi.azurenative.alertsmanagement.enums.Field.Description),
    AlertContext(com.pulumi.azurenative.alertsmanagement.enums.Field.AlertContext),
    ;

    override fun toJava(): com.pulumi.azurenative.alertsmanagement.enums.Field = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.enums.Field): Field =
            Field.values().first { it.javaValue == javaType }
    }
}
