@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.ActionRuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Action rule with action group configuration
 * @property actionGroupId Action group to trigger if action rule matches
 * @property conditions conditions on which alerts will be filtered
 * @property description Description of action rule
 * @property scope scope on which action rule will apply
 * @property status Indicates if the given action rule is enabled or disabled
 * @property type Indicates type of action rule
 * Expected value is 'ActionGroup'.
 */
public data class ActionGroupArgs(
    public val actionGroupId: Output<String>,
    public val conditions: Output<ConditionsArgs>? = null,
    public val description: Output<String>? = null,
    public val scope: Output<ScopeArgs>? = null,
    public val status: Output<Either<String, ActionRuleStatus>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ActionGroupArgs.builder()
            .actionGroupId(actionGroupId.applyValue({ args0 -> args0 }))
            .conditions(conditions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActionGroupArgs].
 */
@PulumiTagMarker
public class ActionGroupArgsBuilder internal constructor() {
    private var actionGroupId: Output<String>? = null

    private var conditions: Output<ConditionsArgs>? = null

    private var description: Output<String>? = null

    private var scope: Output<ScopeArgs>? = null

    private var status: Output<Either<String, ActionRuleStatus>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Action group to trigger if action rule matches
     */
    @JvmName("jnqonjvmkhqbgtsh")
    public suspend fun actionGroupId(`value`: Output<String>) {
        this.actionGroupId = value
    }

    /**
     * @param value conditions on which alerts will be filtered
     */
    @JvmName("mfaukuptkbsjuste")
    public suspend fun conditions(`value`: Output<ConditionsArgs>) {
        this.conditions = value
    }

    /**
     * @param value Description of action rule
     */
    @JvmName("aghuvfttjkkiqkte")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value scope on which action rule will apply
     */
    @JvmName("nragmduxxnuqhvua")
    public suspend fun scope(`value`: Output<ScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("aruqmdmccqhauphf")
    public suspend fun status(`value`: Output<Either<String, ActionRuleStatus>>) {
        this.status = value
    }

    /**
     * @param value Indicates type of action rule
     * Expected value is 'ActionGroup'.
     */
    @JvmName("hlgxfayeptawitbu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Action group to trigger if action rule matches
     */
    @JvmName("lsivelifqoiqfphq")
    public suspend fun actionGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroupId = mapped
    }

    /**
     * @param value conditions on which alerts will be filtered
     */
    @JvmName("kjwipnnpibhankvx")
    public suspend fun conditions(`value`: ConditionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument conditions on which alerts will be filtered
     */
    @JvmName("gneoxvwysdfhxiof")
    public suspend fun conditions(argument: suspend ConditionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConditionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param value Description of action rule
     */
    @JvmName("meirbxqrixgxkeyj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value scope on which action rule will apply
     */
    @JvmName("obtfxouussprsski")
    public suspend fun scope(`value`: ScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument scope on which action rule will apply
     */
    @JvmName("stnebmdvfmmuykkw")
    public suspend fun scope(argument: suspend ScopeArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("jrsivyiwnqlfjcql")
    public suspend fun status(`value`: Either<String, ActionRuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("bxkwtuldgkkefagw")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionRuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates if the given action rule is enabled or disabled
     */
    @JvmName("fyfioeiwmcmosqba")
    public fun status(`value`: ActionRuleStatus) {
        val toBeMapped = Either.ofRight<String, ActionRuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates type of action rule
     * Expected value is 'ActionGroup'.
     */
    @JvmName("vmrsuwqhyvqcslql")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ActionGroupArgs = ActionGroupArgs(
        actionGroupId = actionGroupId ?: throw PulumiNullFieldException("actionGroupId"),
        conditions = conditions,
        description = description,
        scope = scope,
        status = status,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
