@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.AddActionGroupsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Add action groups to alert processing rule.
 * @property actionGroupIds List of action group Ids to add to alert processing rule.
 * @property actionType Action that should be applied.
 * Expected value is 'AddActionGroups'.
 */
public data class AddActionGroupsArgs(
    public val actionGroupIds: Output<List<String>>,
    public val actionType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.AddActionGroupsArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.AddActionGroupsArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.AddActionGroupsArgs.builder()
            .actionGroupIds(actionGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .actionType(actionType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddActionGroupsArgs].
 */
@PulumiTagMarker
public class AddActionGroupsArgsBuilder internal constructor() {
    private var actionGroupIds: Output<List<String>>? = null

    private var actionType: Output<String>? = null

    /**
     * @param value List of action group Ids to add to alert processing rule.
     */
    @JvmName("suvqxrgwoyhmhtie")
    public suspend fun actionGroupIds(`value`: Output<List<String>>) {
        this.actionGroupIds = value
    }

    @JvmName("rolbjggraaddlxra")
    public suspend fun actionGroupIds(vararg values: Output<String>) {
        this.actionGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of action group Ids to add to alert processing rule.
     */
    @JvmName("lrpyvomerkvytxot")
    public suspend fun actionGroupIds(values: List<Output<String>>) {
        this.actionGroupIds = Output.all(values)
    }

    /**
     * @param value Action that should be applied.
     * Expected value is 'AddActionGroups'.
     */
    @JvmName("mvqjqjtyrlmaxmka")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value List of action group Ids to add to alert processing rule.
     */
    @JvmName("msfisofoifckmwhh")
    public suspend fun actionGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroupIds = mapped
    }

    /**
     * @param values List of action group Ids to add to alert processing rule.
     */
    @JvmName("hjwyitrgjaqcxyvs")
    public suspend fun actionGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionGroupIds = mapped
    }

    /**
     * @param value Action that should be applied.
     * Expected value is 'AddActionGroups'.
     */
    @JvmName("bpqkderufufjslpt")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    internal fun build(): AddActionGroupsArgs = AddActionGroupsArgs(
        actionGroupIds = actionGroupIds ?: throw PulumiNullFieldException("actionGroupIds"),
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
    )
}
