@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.CorrelateAlertsArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.NotificationsForCorrelatedAlerts
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Add logic for alerts correlation.
 * @property actionType Action that should be applied.
 * Expected value is 'CorrelateAlerts'.
 * @property correlateBy The list of conditions for the alerts correlations.
 * @property correlationInterval The required duration (in ISO8601 format) for the alerts correlation.
 * @property notificationsForCorrelatedAlerts Indicates how to handle child alerts notifications.
 * @property priority The priority of this correlation.
 */
public data class CorrelateAlertsArgs(
    public val actionType: Output<String>,
    public val correlateBy: Output<List<CorrelateByArgs>>,
    public val correlationInterval: Output<String>,
    public val notificationsForCorrelatedAlerts:
    Output<Either<String, NotificationsForCorrelatedAlerts>>? = null,
    public val priority: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.CorrelateAlertsArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.CorrelateAlertsArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.CorrelateAlertsArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .correlateBy(
                correlateBy.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .correlationInterval(correlationInterval.applyValue({ args0 -> args0 }))
            .notificationsForCorrelatedAlerts(
                notificationsForCorrelatedAlerts?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorrelateAlertsArgs].
 */
@PulumiTagMarker
public class CorrelateAlertsArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var correlateBy: Output<List<CorrelateByArgs>>? = null

    private var correlationInterval: Output<String>? = null

    private var notificationsForCorrelatedAlerts:
        Output<Either<String, NotificationsForCorrelatedAlerts>>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Action that should be applied.
     * Expected value is 'CorrelateAlerts'.
     */
    @JvmName("lnjkrnxnpvnaapjv")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value The list of conditions for the alerts correlations.
     */
    @JvmName("ujifpeunidotlomm")
    public suspend fun correlateBy(`value`: Output<List<CorrelateByArgs>>) {
        this.correlateBy = value
    }

    @JvmName("rcjsjaxbjknthmwb")
    public suspend fun correlateBy(vararg values: Output<CorrelateByArgs>) {
        this.correlateBy = Output.all(values.asList())
    }

    /**
     * @param values The list of conditions for the alerts correlations.
     */
    @JvmName("nyduseqryunrthpn")
    public suspend fun correlateBy(values: List<Output<CorrelateByArgs>>) {
        this.correlateBy = Output.all(values)
    }

    /**
     * @param value The required duration (in ISO8601 format) for the alerts correlation.
     */
    @JvmName("knnqymqokfjrlmui")
    public suspend fun correlationInterval(`value`: Output<String>) {
        this.correlationInterval = value
    }

    /**
     * @param value Indicates how to handle child alerts notifications.
     */
    @JvmName("uqvnujkpcnbpario")
    public suspend
    fun notificationsForCorrelatedAlerts(`value`: Output<Either<String, NotificationsForCorrelatedAlerts>>) {
        this.notificationsForCorrelatedAlerts = value
    }

    /**
     * @param value The priority of this correlation.
     */
    @JvmName("sngolvfcnobvlpkb")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Action that should be applied.
     * Expected value is 'CorrelateAlerts'.
     */
    @JvmName("fkcqklxwlpwutgfj")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The list of conditions for the alerts correlations.
     */
    @JvmName("xxiuwdievmsuafyk")
    public suspend fun correlateBy(`value`: List<CorrelateByArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlateBy = mapped
    }

    /**
     * @param argument The list of conditions for the alerts correlations.
     */
    @JvmName("nhfjyyiffgimyjrv")
    public suspend fun correlateBy(argument: List<suspend CorrelateByArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CorrelateByArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.correlateBy = mapped
    }

    /**
     * @param argument The list of conditions for the alerts correlations.
     */
    @JvmName("aebirmkndhvhhhuy")
    public suspend fun correlateBy(vararg argument: suspend CorrelateByArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CorrelateByArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.correlateBy = mapped
    }

    /**
     * @param argument The list of conditions for the alerts correlations.
     */
    @JvmName("gwptcmyfqfcdhfof")
    public suspend fun correlateBy(argument: suspend CorrelateByArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CorrelateByArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.correlateBy = mapped
    }

    /**
     * @param values The list of conditions for the alerts correlations.
     */
    @JvmName("xumekxviphnstyoo")
    public suspend fun correlateBy(vararg values: CorrelateByArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlateBy = mapped
    }

    /**
     * @param value The required duration (in ISO8601 format) for the alerts correlation.
     */
    @JvmName("jmfcqatmqqipqmsx")
    public suspend fun correlationInterval(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlationInterval = mapped
    }

    /**
     * @param value Indicates how to handle child alerts notifications.
     */
    @JvmName("hlyblxgcgnsqkckb")
    public suspend
    fun notificationsForCorrelatedAlerts(`value`: Either<String, NotificationsForCorrelatedAlerts>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationsForCorrelatedAlerts = mapped
    }

    /**
     * @param value Indicates how to handle child alerts notifications.
     */
    @JvmName("kpdhofksdlpyjdvy")
    public fun notificationsForCorrelatedAlerts(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationsForCorrelatedAlerts>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationsForCorrelatedAlerts = mapped
    }

    /**
     * @param value Indicates how to handle child alerts notifications.
     */
    @JvmName("wwhawxgcwgsblirq")
    public fun notificationsForCorrelatedAlerts(`value`: NotificationsForCorrelatedAlerts) {
        val toBeMapped = Either.ofRight<String, NotificationsForCorrelatedAlerts>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationsForCorrelatedAlerts = mapped
    }

    /**
     * @param value The priority of this correlation.
     */
    @JvmName("xiykgkjlkqyvuhog")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): CorrelateAlertsArgs = CorrelateAlertsArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        correlateBy = correlateBy ?: throw PulumiNullFieldException("correlateBy"),
        correlationInterval = correlationInterval ?: throw PulumiNullFieldException("correlationInterval"),
        notificationsForCorrelatedAlerts = notificationsForCorrelatedAlerts,
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
